package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * Describe: 创建 灰度配置范围
 *
 * @Author xiezhongyong
 * @Date 2021-10-18
 */
@Data
public class CreateCanaryConfigScope {

    @Length(message = "灰度配置ID 最多输入20字符", max = 20)
    @NotEmpty(message = "灰度配置ID 不能为空")
    @ApiModelProperty("灰度配置ID")
    private String canaryConfigId;
    @Length(message = "购方租户ID 最多输入20字符", max = 20)
    @NotEmpty(message = "购方租户ID 不能为空")
    @ApiModelProperty("购方租户ID(0:全部购方)")
    private String purchaserTenantId = "0";
    @Length(message = "购方名称 最多输入200字符", max = 200)
    @NotEmpty(message = "购方名称 不能为空")
    @ApiModelProperty("购方名称")
    private String purchaserTenantName = "全部购方";

    @Valid
    @ApiModelProperty("供应商筛选配置")
    private SellerSelectConfig sellerSelectConfig;

    @ApiModelProperty("供应商筛选配置(前端特供)")
    private JSONObject sellerSelectConfigExt;

    @Size(max = 1000, message = "企业数据ID 范围值[1-1000]")
    @ApiModelProperty("选择企业数据ID")
    private List<Long> selectDataIds;

    @ApiModelProperty("是否全部全选(是:true)")
    private boolean selectAll = false;

}
