package com.xforceplus.ant.coop.rule.center.client.data.canary.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Describe: 灰度协同关系 列表
 *
 * @Author xiezhongyong
 * @Date 2021-10-21
 */
@Data
public class ListCanaryCoordination {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("协同关系ID")
    private String coordinationId;
    @ApiModelProperty("销方公司id(企业ID)")
    private String sellerCompanyId;
    @ApiModelProperty("销方公司名称(企业名称)")
    private String sellerCompanyName;
    @ApiModelProperty("销方税号(企业税号)")
    private String sellerTax;
    @ApiModelProperty("企业来源(1:协同中心;2:手动配置;3:定时器;4:excel导入)")
    private Integer source = 1;
    @ApiModelProperty("购方租户ID")
    private String purchaserTenantId;
    @ApiModelProperty("购方租户名称(协同购方)")
    private String purchaserTenantName;
    @ApiModelProperty("灰度状态(0:未灰度;1:已灰度)")
    private Integer canaryStatus = 0;
    @ApiModelProperty("灰度开始时间(灰度时间)")
    private String canarySrartTime = String.valueOf(System.currentTimeMillis());
}
