package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: displayType-显示方式
 *
 * @Author xiezhongyong
 * @Date 2020-04-24
 */
@Data
public class DisplayTypeLimit extends FieldLimit {

    @NotEmpty(message = "显示方式 不能为空")
    @ApiModelProperty("显示方式 1-文本框 2-下拉框 3-复选框 4-单选 5-多文本框 6-radio单选 7-时间 8-下拉多选 9-区间")
    @Pattern(regexp = "^1$|^2$|^3$|^4$|^5$|^6$|^7$|^8$|^9$", message = "显示方式 不合法")
    private String displayType;



}
