package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Describe: T07 条件校验
 *
 * @Author xiezhongyong
 * @Date 2022-06-02
 */
@Data
public class ConditionCheckBody extends BizConfigBody {

    @Valid
    @Size(min = 1, max = 100, message = "操作符列表 范围[1-100]")
    @ApiModelProperty("操作符列表")
    private List<Operator> operatorList = new ArrayList<>();

    @Valid
    @Size(min = 1, max = 100, message = "单位列表 范围[1-100]")
    @ApiModelProperty("单位列表")
    private List<Unit> unitList = new ArrayList<>();

    @Valid
    @Size(min = 1, max = 100, message = "条件枚举列表 范围[1-100]")
    @ApiModelProperty("条件枚举列表")
    private List<ConditionEnum> conditionEnumList = new ArrayList<>();

    @Valid
    @Size(min = 1, max = 100, message = "校验枚举列表 范围[1-100]")
    @ApiModelProperty("校验枚举列表")
    private List<CheckEnum> checkEnumList = new ArrayList<>();

    @Valid
    @NotNull(message = "配置组范围 不能为空")
    @ApiModelProperty("配置组范围")
    private Range configGroupRange;

    @Valid
    @ApiModelProperty("配置组列表")
    private List<ConfigGroup> configGroupList = new ArrayList<>();

    @ApiModelProperty("校验条件固定描述")
    private String checkFixedDesc;


    /**
     * 配置组
     */
    @Data
    public static class ConfigGroup extends BaseConfigBean{


        @ApiModelProperty("配置组名称")
        private String groupName;

        @ApiModelProperty("配置组描述")
        private String groupDesc;

        @Valid
        @NotNull(message = "条件配置 不能为空")
        @ApiModelProperty("条件配置")
        private ConditionConfig conditionConfig;

        @Valid
        @NotNull(message = "校验配置 不能为空")
        @ApiModelProperty("校验配置")
        private CheckConfig checkConfig;

    }


}
