package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean.target.BaseTarget;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean.target.TolRangeTarget;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.enums.CheckTypeEnum;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: T07 条件校验 配置输出
 *
 * @Author xiezhongyong
 * @Date 2022-06-05
 */
@Data
public class ConditionCheckConfig extends BizConfig {


    /**
     * 配置复杂
     */
    private List<ConfigGroup> configGroupList;

    /**
     * 配置组
     */
    @Data
    public static class ConfigGroup {

        /**
         * 条件配置
         */
        private ConditionConfig conditionConfig;

        /**
         * 校验配置
         */
        private CheckConfig checkConfig;

    }

    @Data
    public static class ConditionConfig {

        /**
         * 条件组列表
         */
        private List<Condition> conditionList = new ArrayList<>();

    }

    /**
     * 条件组对象
     */
    @Data
    public static class Condition {


        /**
         * 条件项列表
         */
        private List<ConditionItem> conditionItemList = new ArrayList<>();
    }


    /**
     * 条件组->条件项对象
     */
    @Data
    public static class ConditionItem {

        /**
         * 字段名称
         */
        private String fieldName;

        /**
         * 字段中文名称
         */
        private String fieldDisplayName;

        /**
         * 操作符
         */
        private String operator;

        /**
         * 对比值
         */
        public String compareValue;

    }

    @Data
    public static class CheckConfig {

        /**
         * 校验项列表
         */
        private List<CheckItem> checkItemList = new ArrayList<>();


    }

    /**
     * 校验项对象
     */
    @Data
    public static class CheckItem {

        /**
         * 字段名称
         */
        private String fieldName;

        /**
         * 字段中文名称
         */
        private String fieldDisplayName;

        /**
         * 校验类型(tolRange:容差范围)
         */
        private String checkType;

        /**
         * 校验目标值
         */
        private JSONObject checkTarget;

        /**
         * 校验目标值,具体的对象
         * 参考 对象: ${@link CheckTypeEnum}
         */
        public <T> T getCheckTarget() {
            CheckTypeEnum checkTypeEnum = CheckTypeEnum.fromValue(this.checkType);
            return (T) checkTarget.toJavaObject(checkTypeEnum.targetClass());
        }


    }
}
