package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;
import java.util.UUID;

/**
 * Describe: BaseConfigBean
 *
 * @Author xiezhongyong
 * @Date 2022-06-09
 */
@Data
public class BaseConfigBean {

    @ApiModelProperty("数据ID")
    private String id = UUID.randomUUID().toString().replaceAll("-", "");

    @Pattern(regexp = "^0$|^1$|^2$|^3$", message = "编辑标记 不合法")
    @ApiModelProperty("编辑标记;0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private String editFlag = "0";

    @Pattern(regexp = "^0$|^1$", message = "初始化标记 不合法")
    @ApiModelProperty("初始化标记;0-非初始化 1-初始化")
    private String initFlag = "0";
}
