package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 校验配置
 *
 * @Author xiezhongyong
 * @Date 2022-06-02
 */
@Data
public class CheckConfig extends BaseConfigBean{


    @ApiModelProperty("校验名称")
    private String checkName;

    @ApiModelProperty("校验描述")
    private String checkDesc;

    @Valid
    @NotNull(message = "校验项范围 不能为空")
    @ApiModelProperty("校验项范围")
    private Range checkItemRange;

    @Valid
    @ApiModelProperty("校验项列表")
    private List<CheckItem> checkItemList = new ArrayList<>();

    /**
     * 校验项对象
     */
    @Data
    public static class CheckItem extends BaseConfigBean{


        @NotEmpty(message = "字段名称 不能为空")
        @ApiModelProperty("字段名称")
        private String fieldName;

        @NotEmpty(message = "字段中文名称 不能为空")
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;

        @NotEmpty(message = "校验类型 不能为空")
        @Pattern(regexp = "^tolRange$", message = "校验类型 不合法")
        @ApiModelProperty("校验类型(tolRange:容差范围)")
        private String checkType;

        @Valid
        @ApiModelProperty("校验目标结果")
        private JSONObject checkTarget;



    }

}
