package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;

/**
 * Describe: 校验枚举对象
 *
 * @Author xiezhongyong
 * @Date 2022-06-02
 */
@Data
public class CheckEnum {
    @NotEmpty(message = "字段名称 不能为空")
    @ApiModelProperty("字段名称")
    private String fieldName;

    @NotEmpty(message = "字段中文名称 不能为空")
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;

    @NotEmpty(message = "校验类型 不能为空")
    @Pattern(regexp = "^tolRange$", message = "校验类型 不合法")
    @ApiModelProperty("校验类型(tolRange:容差范围)")
    private String checkType;

    @Size(min = 1, max = 100, message = "可选单位code列表 范围[1-100]")
    @ApiModelProperty("可选单位code列表")
    private Set<String> units = new HashSet<>();

    @ApiModelProperty("配置限制(-1:无限制,大于0表示具体出现次数限制)")
    private Integer limit = -1;

    @Valid
    @ApiModelProperty("默认值(选择当前枚举后显示的默认值)")
    private JSONObject defaultValue;


}
