package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Describe: 条件配置
 *
 * @Author xiezhongyong
 * @Date 2022-06-02
 */
@Data
public class ConditionConfig extends BaseConfigBean{


    @Valid
    @NotNull(message = "条件组范围 不能为空")
    @ApiModelProperty("条件组范围")
    private Range conditionRange;

    @Valid
    @ApiModelProperty("条件组列表")
    private List<Condition> conditionList = new ArrayList<>();

    /**
     * 条件组对象
     */
    @Data
    public static class Condition extends BaseConfigBean{

        @ApiModelProperty("条件组名称")
        private String conditionName;

        @ApiModelProperty("条件组描述")
        private String conditionDesc;

        @Valid
        @NotNull(message = "条件项范围 不能为空")
        @ApiModelProperty("条件项范围")
        private Range conditionItemRange;

        @Valid
        @ApiModelProperty("条件组->条件项列表")
        private List<ConditionItem> conditionItemList = new ArrayList<>();
    }


    /**
     * 条件组->条件项对象
     */
    @Data
    public static class ConditionItem extends BaseConfigBean{

        @NotEmpty(message = "字段名称 不能为空")
        @ApiModelProperty("字段名称")
        private String fieldName;

        @NotEmpty(message = "字段中文名称 不能为空")
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;

        @ApiModelProperty("操作符")
        private String operator;

        @ApiModelProperty("对比值(操作符只读时可以为空)")
        public String compareValue;


    }

}
