package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 条件对比类型
 *
 * @Author xiezhongyong
 * @Date 2022/6/6
 */
public enum CompareTypeEnum implements IEnum<String> {


    TEXT("1", "文本框"),
    SINGLE_SELECT("2", "下拉单选");

    private final String code;
    private final String message;

    CompareTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }


    public static CompareTypeEnum fromValue(String code) {
        return Arrays.stream(CompareTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
