package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.condition.ConditionBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.condition.ConditionConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.ConditionCheckBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.ConditionCheckConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect.MultSelectBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect.MultSelectConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.range.RangeBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.range.RangeConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.singleselect.SingleSelectBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.singleselect.SingleSelectConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.switchconfig.SwitchBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.switchconfig.SwitchConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.textcontent.TextContentBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.textcontent.TextContentConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig.TolRangeBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig.TolRangeConfig;

import java.util.Arrays;

/**
 * Describe: 组件类型枚举列表
 *
 * @Author xiezhongyong
 * @Date 2021-03-02
 */
public enum BizConfigTypeEnum {

    BIZ_ITEM_01("T01", "基础开关组件", SwitchBody.class, SwitchConfig.class),
    BIZ_ITEM_02("T02", "容差配置组件", TolRangeBody.class, TolRangeConfig.class),
    BIZ_ITEM_03("T03", "多选组件", MultSelectBody.class, MultSelectConfig.class),
    BIZ_ITEM_04("T04", "单选组件", SingleSelectBody.class, SingleSelectConfig.class),
    BIZ_ITEM_05("T05", "区间组件", RangeBody.class, RangeConfig.class),
    BIZ_ITEM_06("T06", "条件组件", ConditionBody.class, ConditionConfig.class),
    BIZ_ITEM_07("T07", "条件及校验组件", ConditionCheckBody.class, ConditionCheckConfig.class),
    BIZ_ITEM_08("T08","文本内容组件",TextContentBody.class, TextContentConfig .class);

    private final String code;
    private final String message;
    private Class configBodyClass;
    private Class configClass;

    BizConfigTypeEnum(String code, String message, Class configBodyClass, Class configClass) {
        this.code = code;
        this.message = message;
        this.configBodyClass = configBodyClass;
        this.configClass = configClass;
    }

    public String code() {
        return code;
    }


    public Class configBodyClass() {
        return configBodyClass;
    }

    public Class configClass() {
        return configClass;
    }

    public String message() {
        return message;
    }

    public static BizConfigTypeEnum fromValue(String code) {
        return Arrays.stream(BizConfigTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }

    public static BizConfigTypeEnum fromMessage(String message) {
        return Arrays.stream(BizConfigTypeEnum.values())
                .filter(s -> s.message.equals(message))
                .findAny()
                .orElse(null);
    }
}
