package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect.enums.MultSelectFixEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect.enums.MultSelectStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.*;

/**
 * Describe: 多选组件
 * 1、支持多选
 * 2、支持默认值选项
 * 3、支持默认值禁改
 *
 * @Author xiezhongyong
 * @Date 2022-04-08
 */
@Data
public class MultSelectBody extends BizConfigBody {

    @Valid
    @ApiModelProperty("选择值列表")
    private List<MultValue> values = new ArrayList<>();

    @Valid
    @NotNull(message = "可选择项 不能为空")
    @Size(min = 1, max = 100, message = "可选择项范围[1-100]")
    @ApiModelProperty("可选择项列表")
    private List<MultOption> options = new ArrayList<>();


    /**
     * 选择值
     */
    @Data
    public static class MultValue {
        @NotEmpty(message = "选项值 不能为空")
        @ApiModelProperty("选项值")
        private String value;

        @NotEmpty(message = "固定标识 不能为空")
        @Pattern(regexp = "^Y$|^N$", message = "固定枚举标识 不合法")
        @ApiModelProperty("固定标识(Y:固定为禁改项，N:非固定(默认))")
        private String fix = MultSelectFixEnum.N.code();

    }

    /**
     * 可选择项
     */
    @Data
    public static class MultOption {
        @NotEmpty(message = "选项状态 不能为空")
        @Pattern(regexp = "^1$|^0$", message = "选项状态 不合法")
        @ApiModelProperty("选项状态(1:启用;0:停用)")
        private String status = MultSelectStatusEnum.ENABLED.code();
        @NotEmpty(message = "选项值 不能为空")
        @ApiModelProperty("选项值")
        private String value;
        @NotEmpty(message = "选项文本 不能为空")
        @ApiModelProperty("选项文本")
        private String text;

    }
}
