package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 多选组件 默认值 固定、非固定
 *
 * @Author xiezhongyong
 * @Date 2022/4/8
 */
public enum MultSelectFixEnum implements IEnum<String> {

    Y("Y", "固定(不可修改)"),
    N("N", "非固定(可修改)");

    private final String code;
    private final String message;

    MultSelectFixEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static MultSelectFixEnum fromValue(String code) {
        return Arrays.stream(MultSelectFixEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
