package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.range;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.range.enums.RangeFixEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * Describe: 区间组件
 *
 * @Author xiezhongyong
 * @Date 2022-04-13
 */
@Data
public class RangeBody extends BizConfigBody {

    @Valid
    @NotNull(message = "最小值(下限) 不能为空")
    @ApiModelProperty("最小值(下限)")
    private RangeValue min;

    @Valid
    @NotNull(message = "最大值(上限) 不能为空")
    @ApiModelProperty("最大值(上限)")
    private RangeValue max;


    @Data
    public static class RangeValue{
        @NotEmpty(message = "数值 不能为空")
        @Pattern(regexp = "^[+-]?(0|([1-9]\\d*))(\\.\\d+)?$", message = "值 不合法")
        @ApiModelProperty("值")
        private String value;

        @NotEmpty(message = "固定标识 不能为空")
        @Pattern(regexp = "^Y$|^N$", message = "固定枚举标识 不合法")
        @ApiModelProperty("固定标识(Y:固定为禁改项，N:非固定(默认))")
        private String fix = RangeFixEnum.N.code();

        @Pattern(regexp = "^[+-]?(0|([1-9]\\d*))(\\.\\d+)?$", message = "数值限制 不合法")
        @ApiModelProperty("数值限制")
        private String limit;
    }


}
