package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.range.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 区间组件 默认值 固定、非固定
 *
 * @Author xiezhongyong
 * @Date 2022/4/8
 */
public enum RangeFixEnum implements IEnum<String> {

    Y("Y", "固定(不可修改)"),
    N("N", "非固定(可修改)");

    private final String code;
    private final String message;

    RangeFixEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static RangeFixEnum fromValue(String code) {
        return Arrays.stream(RangeFixEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
