package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.singleselect;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.singleselect.enums.SingleSelectStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 单选组件
 *
 * @Author xiezhongyong
 * @Date 2022-04-13
 */
@Data
public class SingleSelectBody extends BizConfigBody {

    @ApiModelProperty("选择值")
    private String value;

    @Valid
    @NotNull(message = "可选择项 不能为空")
    @Size(min = 1,max = 100,message = "可选择项范围[1-100]")
    @ApiModelProperty("可选择项")
    private List<SingleOption> options = new ArrayList<>();

    /**
     * 可选择项
     */
    @Data
    public static class SingleOption {
        @NotEmpty(message = "选项状态 不能为空")
        @Pattern(regexp = "^1$|^0$", message = "选项状态 不合法")
        @ApiModelProperty("选项状态(1:启用;0:停用)")
        private String status = SingleSelectStatusEnum.ENABLED.code();
        @NotEmpty(message = "选项值 不能为空")
        @ApiModelProperty("选项值")
        private String value;
        @NotEmpty(message = "选项文本 不能为空")
        @ApiModelProperty("选项文本")
        private String text;

    }
}
