package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.singleselect.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 单选组件 选择性状态
 *
 * @Author xiezhongyong
 * @Date 2022/4/13
 */
public enum SingleSelectStatusEnum implements IEnum<String> {


    ENABLED("1", "启用"),
    DISABLED("0", "停用");

    private final String code;
    private final String message;

    SingleSelectStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static SingleSelectStatusEnum fromValue(String code) {
        return Arrays.stream(SingleSelectStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
