package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.switchconfig.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 基础开关配置-开关状态枚举配置
 *
 * @Author xiezhongyong
 * @Date 2022-03-07
 */
public enum SwitchStatusEnum implements IEnum<String> {


    ENABLED("1", "启用"),
    DISABLED("0", "停用");

    private final String code;
    private final String message;

    SwitchStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static SwitchStatusEnum fromValue(String code) {
        return Arrays.stream(SwitchStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
