package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.textcontent;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.textcontent.enums.TextTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 文本组件
 *
 * @Author xiezhongyong
 * @Date 2024/3/26 11:06
 */
@Data
public class TextContentBody extends BizConfigBody {

    @NotEmpty(message = "名称 不能为空")
    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("后缀")
    private String suffix;

    @NotEmpty(message = "类型 不能为空")
    @Pattern(regexp = "^number$|^string$|^date$|^datetime$", message = "类型 不合法")
    @ApiModelProperty("类型")
    private String type = TextTypeEnum.STRING.code();

    @NotEmpty(message = "数值 不能为空")
    @ApiModelProperty("数值")
    private String value;
    @ApiModelProperty("最大值")
    private String max;
    @ApiModelProperty("最小值")
    private String min;
}
