package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.textcontent.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 文本内容类型
 *
 * @Author xiezhongyong
 * @Date 2024/3/26 11:02
 */
public enum TextTypeEnum implements IEnum<String> {


    NUMBER("number", "数值"),
    STRING("string", "字符串"),
    DATE("date", "日期"),
    DATETIME("datetime", "日期+时间");


    private final String code;
    private final String message;

    TextTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static TextTypeEnum fromValue(String code) {
        return Arrays.stream(TextTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
