package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;

/**
 * Describe: tolRangeconfig
 *
 * @Author xiezhongyong
 * @Date 2022-02-09
 */
@Data
public class TolRangeBody extends BizConfigBody {

    // 开关部分
    @ApiModelProperty("开关状态,默认关闭(0:开启;1:关闭)")
    @Pattern(regexp = "^0$|^1$", message = "开关状态 不合法")
    private String switchStatus = "1";

    // 容差部分
    @ApiModelProperty("最小区间值(数值)")
    private String minValue;
    @ApiModelProperty("最大区间值(数值)")
    private String maxValue;
    @ApiModelProperty("单位 0-固定金额（默认） 1-百分比")
    @Pattern(regexp = "^0$|^1$", message = "单位 不合法")
    private String unit = "0";
}
