package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfigBody;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig.enums.TolRangeStatusEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig.enums.TolRangeUnitEnum;
import com.xforceplus.ant.coop.rule.center.client.data.utils.IEnumConvert;
import lombok.Data;
/**
 * Describe: 容差范围配置内容
 *
 * @Author xiezhongyong
 * @Date 2022-02-09
 */
@Data
public class TolRangeConfig extends BizConfig {

    /**
     * 配置开关 参考 {@link TolRangeStatusEnum}
     */
    @JSONField(serializeUsing = IEnumConvert.class, deserializeUsing = IEnumConvert.class)
    private TolRangeStatusEnum switchStatus;

    /**
     * 最小区间值(数值)
     */
    private String minValue;

    /**
     * 最大区间值(数值)
     */
    private String maxValue;

    /**
     * 单位 参考 {@link TolRangeUnitEnum}
     */
    @JSONField(serializeUsing = IEnumConvert.class, deserializeUsing = IEnumConvert.class)
    private TolRangeUnitEnum unit;
}
