package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 业务配置项 转换后的状态值
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum BizFieldStatusEnum {

    Y("Y", "开启"),
    N ("N", "关闭");

    private final String code;
    private final String message;

    BizFieldStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static BizFieldStatusEnum fromValue(String code) {
        return Arrays.stream(BizFieldStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
