package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想
 * @Author xiezhongyong
 * @Date 2021-06-01
 */
public enum FieldTypeEnum {

    A("a", "多文本"),
    S("s", "文本"),
    N("n", "数值"),
    D("d", "日期"),
    T("t", "时间");

    private final String code;
    private final String message;

    FieldTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static FieldTypeEnum fromValue(Integer code) {
        return Arrays.stream(FieldTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
