package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 返回数据结构类型 0：列表结构；1：分组结构
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum ViewTypeEnum {

    LIST(0, "列表结构"),
    GROUP (1, "分组结构");

    private final Integer code;
    private final String message;

    ViewTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static ViewTypeEnum fromValue(Integer code) {
        return Arrays.stream(ViewTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
