package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 发票基础配置
 * 3003001	业务模板	invoice-config	发票基础-配置模板	发票	3003001
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum InvoiceBasicConfigEnum implements IBasicConfigEnum {


    NEW_BILL("coopNewBillOnRedDeposeFlag", "红冲作废重生结算单"),
    ASSOCIATE_CANCEL_AFTER_AUTH("coopAssociateCancelAfterAuth", "认证后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_SCAN("coopAssociateCancelAfterScan", "扫描后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_RED("coopAssociateCancelAfterRed", "红冲后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_ABANDON("coopAssociateCancelAfterAbandon", "作废后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_PAY("coopAssociateCancelAfterPay", "发票付款后可取消关联"),



    // 以下是新增配置
    COOP_INVOICE_LOCK_NOT_INVALID("coopInvoiceLockNotInvalid","发票锁定后不可作废"),
    COOP_INVOICE_LOCK_NOT_RED("coopInvoiceLockNotRed","发票锁定后不可红冲"),
    COOP_INVOICE_SCAN_NOT_INVALID("coopInvoiceScanNotInvalid","发票已扫描不可作废"),
    COOP_INVOICE_SCAN_NOT_RED("coopInvoiceScanNotRed","发票已扫描不可红冲"),
    COOP_INVOICE_AUTH_NOT_INVALID("coopInvoiceAuthNotInvalid","发票已认证不可作废"),
    COOP_INVOICE_AUTH_NOT_RED("coopInvoiceAuthNotRed","发票已认证不可红冲"),
//    COOP_INVOICE_OPENER_LOCK("coopInvoiceOpenerLock","发票开具后是否锁定"),
    COOP_INVOICE_RED_TYPE_MUTUAL("coopInvoiceRedTypeMutual","红冲类型支持纸电互冲"),
    COOP_SPLIT_RULE_ADAPTER_BILL_TYPE("coopSplitRuleAdapterBillType","拆票规则适配单据类型"),
    COOP_PRE_INVOICE_BACK_FILL("coopPreInvoiceBackFill","预制发票回填明细控制(开启:预制发票;关闭:查验)"),
    COOP_INVOICE_REMARK_FIELD_CHECK("coopInvoiceRemarkFieldCheck","发票备注字段检验(开启:检验;关闭:不校验)"),
    COOP_INVOICE_RETREAT_IS_RELEASE_LOCK("coopInvoiceRetreatIsReleaseLock","退票后是否解锁发票，默认关闭（否）"),
    COOP_INVOICE_PAYMENT_METHOD("coopInvoicePaymentMethod","是否展示发票付款计划(启用:付款计划;停用[默认]:付款状态)"),
    COOP_INVOICE_CHECK_NOT_ASSOCIATE("coopInvoiceCheckNotAssociate","勾选后可取消关联(默认关)"),
    COOP_INVOICE_CHECK_NOT_DEPOSE("coopInvoiceCheckNotDepose","勾选后不可作废(默认关)"),
    COOP_INVOICE_CHECK_NOT_RED("coopInvoiceCheckNotRed","勾选后不可红冲(默认关)"),
    COOP_INVOICE_IMAGE_STATE("coopInvoiceImageState","勾选后不可红冲(默认关)"),
    @Deprecated
    COOP_INVOICE_OFD_CONVERT_PDF("coopInvoiceOfdConvertPdf","OFD文件是否转PDF(开启:是;关闭:否[默认])"),
    @Deprecated
    COOP_INVOICE_OFD_CONVERT_IMAGE("coopInvoiceOfdConvertImage","OFD文件是否转图片(开启:是;关闭:否[默认])"),
    COOP_INVOICE_OFD_ISSUE_WAY("coopInvoiceOfdIssueWay","OFD电票数据下发格式选项"),
    COOP_INVOICE_SK_CS_SYNC_FORMAT("coopInvoiceSkCsSyncFormat","税控纸质发票数据下发格式设置"),

    COOP_INVOICE_CHARGE_UP_NOT_INVALID("coopInvoiceChargeUpNotInvalid","发票购方记账后不可作废"),
    COOP_INVOICE_CHARGE_UP_NOT_RED("coopInvoiceChargeUpNotRed","发票购方记账后不可红冲"),

    COOP_INVOICE_LOCK_NOT_ASSOCIATE("coopInvoiceLockNotAssociate", "发票锁定后不可取消关联"),



    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 3003001;
    private Long commonTemplateId = 3003001L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    InvoiceBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static InvoiceBasicConfigEnum fromValue(String code) {
        InvoiceBasicConfigEnum anEnum = Arrays.stream(InvoiceBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
