package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 供应商-结算规则基础配置
 * 3005001	业务模板	srBasicConfig	结算规则基础配置	结算	3005001
 *
 * @Author xiezhongyong
 * @Date 2020-07-29
 */
public enum SrBasicConfigEnum implements IBasicConfigEnum {

    BILL_IMPORT_DISCOUNT_MAP_TYPE("billImportDiscountMapType", "结算单导入折扣额映射方式(关闭:价内;开启:价外)"),

    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 3005001;
    private Long commonTemplateId = 3005001L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    SrBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static SrBasicConfigEnum fromValue(String code) {
        SrBasicConfigEnum anEnum = Arrays.stream(SrBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
