package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 结算单容差基础配置
 * 3001002	业务模板	backfillTolCfg	结算单发票容差-配置模板	结算单	3001002
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum ToleranceConfigEnum implements IBasicConfigEnum {

    BLUE_BACKFILL_WITH_TAX_TOL_CFG("blueBackfillWithTaxTolCfg", "蓝字发票回填容差配置-含税"),

    BLUE_BACKFILL_WITHOUT_TAX_TOL_CFG("blueBackfillWithoutTaxTolCfg", "蓝字发票回填容差配置-不含税"),
    BLUE_BACKFILL_TAX_TOL_CFG("blueBackfillTaxTolCfg", "蓝字发票回填容差配置-税额"),
    RED_BACKFILL_WITH_TAX_TOL_CFG("redBackfillWithTaxTolCfg", "红字发票回填容差配置-含税"),

    RED_BACKFILL_WITHOUT_TAX_TOL_CFG("redBackfillWithoutTaxTolCfg", "红字发票回填容差配置-不含税"),
    RED_BACKFILL_TAX_TOL_CFG("redBackfillTaxTolCfg", "红字发票回填容差配置-税额"),
    WHOLE_BACKFILL_WITH_TAX_TOL_CFG("wholeBackfillWithTaxTolCfg", "发票回填整单容差配置-含税"),
    WHOLE_BACKFILL_WITHOUT_TAXTOLCFG("wholeBackfillWithoutTaxTolCfg", "发票回填整单容差配置-不含税"),
    WHOLE_BACKFILL_TAX_TOL_CFG("wholeBackfillTaxTolCfg", "发票回填整单容差配置-税额"),
    @Deprecated
    ALONE_TAX_BACKFILL_WITH_TAX_TOL_CFG("aloneTaxBackfillWithTaxTolCfg", "单税率回填容差配置-含税"),
    @Deprecated
    ALONE_TAX_BACKFILL_WITHOUT_TAX_TOL_CFG("aloneTaxBackfillWithoutTaxTolCfg", "单税率回填容差配置-不含税"),
    @Deprecated
    ALONE_TAX_BACKFILL_TAX_TOL_CFG("aloneTaxBackfillTaxTolCfg", "单税率回填容差配置-税额"),


    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 3001002;
    private Long commonTemplateId = 3001002L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    ToleranceConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static ToleranceConfigEnum fromValue(String code) {
        ToleranceConfigEnum anEnum = Arrays.stream(ToleranceConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
