package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * Describe: 单据类型批量修改
 *
 * @Author xiezhongyong
 * @Date 2021-12-10
 */
@Data
public class BatchUpdateBillType {

    @ApiModelProperty("配置ID")
    @NotNull(message = "配置ID 不能为空")
    private Long coopConfigId;

    @Size(max = 100)
    @NotNull(message = "单据类型列表不能为空")
    private List<BillType> billTypeList;


    @Data
    public static class BillType {
        @ApiModelProperty("单据ID")
        @NotNull(message = "单据ID 不能为空")
        private Long id;
        @ApiModelProperty("排序值")
        private Integer sort;
        @ApiModelProperty("单据状态(1:启用;0:停用)")
        @Pattern(regexp = "^0$|^1$", message = "单据状态 不合法")
        private String status;

    }

}
