package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;
import java.util.Map;

/**
 * Describe: 复制条件查询 业务模板（POST）
 *
 * @Author xiezhongyong
 * @Date 2020-06-01
 */
@Data
public class ListBizTemplateDetail {

    @NotNull(message = "配置方ID 不能为空")
    @ApiModelProperty("配置方ID")
    private Long configObjId;
    @NotNull(message = "modelType 不能为空")
    @ApiModelProperty("modelType")
    private Integer modelType;
    @ApiModelProperty("购方配置分类ID")
    private Long coopConfigClassId;
    @ApiModelProperty("数据结构类型 0：列表结构(默认)；1：分组结构")
    @Pattern(regexp = "^0$|^1$", message = "数据结构类型 不合法")
    private String viewType = "0";
    @ApiModelProperty("购方未配置时是否接受通用模板 0：接受（默认）；1：不接受")
    @Pattern(regexp = "^0$|^1$", message = "是否接受通用模板 不合法")
    private String commonFlag = "0";
    @ApiModelProperty("附加查询条件")
    private ComplexParam complexParam = new ComplexParam();

    @Data
    public static class ComplexParam {
        @ApiModelProperty("字段限制")
        private Map<String, Object> limiters;

        @ApiModelProperty("字段过滤")
        private List<String> fields;
    }
}
