package com.xforceplus.ant.coop.rule.center.client.data.cc.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Objects;

/**
 * Describe: 协同配置 详情
 *
 * @Author xiezhongyong
 * @Date 2023/12/11 15:41
 */
public class SyncCoopConfigResult {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("配置方ID(租户ID、企业ID 等)")
    private String configObjId;
    @ApiModelProperty("配置方名称")
    private String configObjName;
    @ApiModelProperty("配置方code")
    private String configObjCode;
    @ApiModelProperty("配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置")
    private Integer configType;
    @ApiModelProperty("分类ID")
    private String coopConfigClassId;
    @ApiModelProperty("状态 0-启用(默认) 1-停用")
    private Integer status;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("更新人")
    private String updateUser;
    @ApiModelProperty("更新人姓名")
    private String updateUserName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConfigObjId() {
        return configObjId;
    }

    public void setConfigObjId(String configObjId) {
        this.configObjId = configObjId;
    }

    public String getConfigObjName() {
        return configObjName;
    }

    public void setConfigObjName(String configObjName) {
        this.configObjName = configObjName;
    }

    public String getConfigObjCode() {
        return configObjCode;
    }

    public void setConfigObjCode(String configObjCode) {
        this.configObjCode = configObjCode;
    }

    public Integer getConfigType() {
        return configType;
    }

    public void setConfigType(Integer configType) {
        this.configType = configType;
    }


    public String getCoopConfigClassId() {
        return coopConfigClassId;
    }

    public void setCoopConfigClassId(String coopConfigClassId) {
        this.coopConfigClassId = coopConfigClassId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SyncCoopConfigResult that = (SyncCoopConfigResult) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(configObjId, that.configObjId) &&
                Objects.equals(configObjName, that.configObjName) &&
                Objects.equals(configObjCode, that.configObjCode) &&
                Objects.equals(configType, that.configType) &&
                Objects.equals(coopConfigClassId, that.coopConfigClassId) &&
                Objects.equals(status, that.status) &&
                Objects.equals(createTime, that.createTime) &&
                Objects.equals(createUser, that.createUser) &&
                Objects.equals(createUserName, that.createUserName) &&
                Objects.equals(updateTime, that.updateTime) &&
                Objects.equals(updateUser, that.updateUser) &&
                Objects.equals(updateUserName, that.updateUserName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, configObjId, configObjName, configObjCode, configType, coopConfigClassId, status, createTime, createUser, createUserName, updateTime, updateUser, updateUserName);
    }
}
