package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Describe: 业务配置详情
 *
 * @Author xiezhongyong
 * @Date 2022/3/9
 */
@Data
public class BizConfigDetail {
    @ApiModelProperty("数据ID")
    private String id;

    @ApiModelProperty("模型类型(类似模板层面归类)")
    private Integer modelType;

    @ApiModelProperty("协同配置ID")
    private String coopConfigId;

    @ApiModelProperty("配置方ID")
    private String configObjId;

    @ApiModelProperty("关联对象ID")
    private String bindObjId;

    @ApiModelProperty("关联对象code")
    private String bindObjCode;

    @ApiModelProperty("关联对象名称")
    private String bindObjName;

    @ApiModelProperty("关联对象类型;1-租户(默认) 2-企业")
    private Integer bindObjType;

    @ApiModelProperty("单据类型ID")
    private String billTypeId;

    @ApiModelProperty("适用范围;0-通用 1-限定条件")
    private Integer applyRange;

    @ApiModelProperty("通用配置标记;0-否(默认) 1-是")
    private Integer commonFlag;

    @ApiModelProperty("配置来源;0-规则中心(默认) 1-业务")
    private Integer configSource;

    @ApiModelProperty("父配置ID")
    private String parentConfigId;

    @ApiModelProperty("配置代码(字段名)")
    private String configCode;

    @ApiModelProperty("配置名称")
    private String configName;

    @ApiModelProperty("配置类型")
    private String configType;

    @ApiModelProperty("配置内容JSON")
    private JSONObject configBody;

    @ApiModelProperty("配置描述")
    private String configDesc;

    @ApiModelProperty("条件MD5")
    private String conditionMd5;

    @ApiModelProperty("分组代码")
    private String groupCode;

    @ApiModelProperty("分组名称")
    private String groupName;

    @ApiModelProperty("分组下标")
    private Integer groupIndex;

    @ApiModelProperty("条件表达式")
    private String conditionExp;

    @ApiModelProperty("配置内容结果(配置结果简化,方便业务调用)")
    private JSONObject configResult;

    // 附加显示字段
    @ApiModelProperty("单据类型名称")
    private String billTypeName;

    @ApiModelProperty("模板分类名称")
    private String templateClassName;
}
