package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 通用数据模板字段 列表
 *
 * @Author xiezhongyong
 * @Date 2020-03-17
 */
@Data
public class DataTemplateField {

    @ApiModelProperty("字段分组代码")
    private String fieldGroup;
    @ApiModelProperty("字段分组名称")
    private String fieldGroupName;
    @ApiModelProperty("字段分组下标")
    private Integer fieldGroupIndex;
    @ApiModelProperty("字段列表")
    private List<FieldType> fieldTypes = new ArrayList<>();

    @Data
    public static class FieldType {
        @ApiModelProperty("下标/排序")
        private Integer index;
        @ApiModelProperty("字段分组名称")
        private String title;
        @ApiModelProperty("字段列表")
        private List<Field> fields = new ArrayList<>();
    }

    @Data
    public static class Field {
        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("排序")
        private Integer sort;
        @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
        private Integer editFlag;
        @ApiModelProperty("字段删除标记  0-正常  1-删除")
        private Integer deleteFlag;

    }
}
