package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * Describe: 业务配置 列表
 *
 * @Author xiezhongyong
 * @String 2020-03-26
 */
@Data
public class ListBizConfig {

    @ApiModelProperty("数据ID")
    private String id;

    @ApiModelProperty("模型类型(类似模板层面归类)")
    private Integer modelType;

    @ApiModelProperty("协同配置ID")
    private String coopConfigId;

    @ApiModelProperty("配置范围;0-购方配置(默认) 1-供应商配置 2-渠道商配置 10-通用")
    private Integer configScope;

    @ApiModelProperty("配置方ID")
    private String configObjId;

    @ApiModelProperty("关联对象ID")
    private String bindObjId;

    @ApiModelProperty("关联对象code")
    private String bindObjCode;

    @ApiModelProperty("关联对象名称")
    private String bindObjName;

    @ApiModelProperty("关联对象类型;1-租户(默认) 2-企业")
    private Integer bindObjType;

    @ApiModelProperty("继承标识;0-不允许继承 1-允许单继承(默认) 2-允许多继承")
    private Integer extendsFlag;

    @ApiModelProperty("单据类型ID")
    private String billTypeId;

    @ApiModelProperty("适用范围;0-通用 1-限定条件")
    private Integer applyRange;

    @ApiModelProperty("配置来源;0-规则中心(默认) 1-业务配置")
    private Integer configSource;

    @ApiModelProperty("业务配置分组ID")
    private String configGroupId;

    @ApiModelProperty("配置代码(字段名)")
    private String configCode;

    @ApiModelProperty("配置名称")
    private String configName;

    @ApiModelProperty("配置类型")
    private String configType;

    @ApiModelProperty("配置描述")
    private String configDesc;

    @ApiModelProperty("条件开关;1-支持配置 0-不支持配置")
    private Integer conditionActive;

    @ApiModelProperty("条件类型;1-生效条件 0-失效条件")
    private Integer conditionType;

    @ApiModelProperty("条件状态;1-启用 0-停用")
    private Integer conditionStatus;


    @ApiModelProperty("分组代码")
    private String groupCode;

    @ApiModelProperty("分组名称")
    private String groupName;

    @ApiModelProperty("分组下标")
    private Integer groupIndex;

    @ApiModelProperty("版本号")
    private String version;

    @ApiModelProperty("状态(停用配置无法被继承);1-启用(默认) 0-停用")
    private Integer status;

    @ApiModelProperty("单据类型编辑标记 1-必须有单据类型才能修改 0-无需单据类型可以修改")
    private Integer billTypeEditFlag;

    @ApiModelProperty("编辑标记;0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("创建人姓名")
    private String createUserName;


}
