package com.xforceplus.ant.coop.rule.center.client.data.cc.tool;

import com.xforceplus.ant.coop.rule.center.client.api.cc.BizTemplateConfigApi;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.BizFieldStatusEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.BizCfgItemStatusEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.CommonFlagEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.ConfigTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg.IBasicConfigEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.GetBizTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.BizTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Map;

/**
 * Describe: 业务配置处理工具类
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
@Slf4j
public class BizTemplateConfigTool {

    /**
     * 读取购方业务配置项值
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return Y-开启 N-关闭
     */
    @Deprecated
    public static String getCfgItemValue(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId) {
        return getCfgItemValue(api, ConfigTypeEnum.PURCHASER, basicConfigEnum, configObjId, null, null, null, CommonFlagEnum.ACCEPT);
    }

    /**
     * 读取购方业务配置项值
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return Y-开启 N-关闭
     */
    public static String getCfgItemValue(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId, String billTypeName) {
        return getCfgItemValue(api, ConfigTypeEnum.PURCHASER, basicConfigEnum, configObjId, null, billTypeName, null, CommonFlagEnum.ACCEPT);
    }

    /**
     * 读取购方业务配置项值
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return Y-开启 N-关闭
     */
    @Deprecated
    public static String getCfgItemValue(BizTemplateConfigApi api, ConfigTypeEnum configTypeEnum, IBasicConfigEnum basicConfigEnum, Long configObjId) {
        return getCfgItemValue(api, configTypeEnum, basicConfigEnum, configObjId, null, null, null, CommonFlagEnum.ACCEPT);
    }

    /**
     * 读取购方业务配置项值
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return Y-开启 N-关闭
     */
    @Deprecated
    public static String getCfgItemValue(BizTemplateConfigApi api, ConfigTypeEnum configTypeEnum, IBasicConfigEnum basicConfigEnum, Long configObjId, String billTypeName) {
        return getCfgItemValue(api, configTypeEnum, basicConfigEnum, configObjId, null, billTypeName, null, CommonFlagEnum.ACCEPT);
    }

    /**
     * 读取购方业务配置项值
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return Y-开启 N-关闭
     */
    @Deprecated
    public static String getCfgItemValue(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId, Map<String, Object> limiters, CommonFlagEnum commonFlagEnum) {
        return getCfgItemValue(api, ConfigTypeEnum.PURCHASER, basicConfigEnum, configObjId, null, null, limiters, commonFlagEnum);
    }


    /**
     * 读取业务配置项值
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return Y-开启 N-关闭
     */
    @Deprecated
    public static String getCfgItemValue(BizTemplateConfigApi api, ConfigTypeEnum configTypeEnum, IBasicConfigEnum basicConfigEnum, Long configObjId, Long bindObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlagEnum) {
        try {
            // 字段过滤
            BaseResult<BizTemplateDetail> response = getBizDetail(api, configTypeEnum, basicConfigEnum, configObjId, bindObjId, billTypeName, limiters, commonFlagEnum);
            log.info("##### 读取业务配置项值,接口响应：{}", JsonUtils.writeObjectToFastJson(response));
            if (ResultCode.SUCCESS.code().equals(response.getCode()) && null != response.getResult() && !response.getResult().getCfgItems().isEmpty()) {
                BizTemplateDetail.CfgItem cfgItem = response.getResult().getCfgItems().get(0);
                // *** 目前并未进行配置项条件验证
                Integer fieldValue = cfgItem.getFieldValue();
                if (BizCfgItemStatusEnum.ENABLED.code().equals(fieldValue)) {
                    log.warn("##### 租户ID:{}；模板modelType:{}；返回值：{},读取内容：{}", configObjId, basicConfigEnum.modelType(), BizFieldStatusEnum.Y.code(), JsonUtils.writeObjectToFastJson(response));
                    return BizFieldStatusEnum.Y.code();
                }
            }
            log.warn("##### 租户ID:{}；模板modelType:{}；返回值：{},读取内容：{}", configObjId, basicConfigEnum.modelType(), BizFieldStatusEnum.N.code(), JsonUtils.writeObjectToFastJson(response));
            return BizFieldStatusEnum.N.code();
        } catch (Exception e) {
            log.warn("##### 租户ID:{}；模板modelType:{}读取配置异常：{}", configObjId, basicConfigEnum.modelType(), e);
            return BizFieldStatusEnum.N.code();
        }
    }

    /**
     * 读取购方业务配置项
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @return BizTemplateDetail.CfgItem
     */
    @Deprecated
    public static BizTemplateDetail.CfgItem getCfgItem(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId) {
        return getCfgItem(api, basicConfigEnum, configObjId, null, null, CommonFlagEnum.ACCEPT);
    }

    /**
     * 读取购方业务配置项
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @param commonFlag
     * @return BizTemplateDetail.CfgItem
     */
    @Deprecated
    public static BizTemplateDetail.CfgItem getCfgItem(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId, CommonFlagEnum commonFlag) {
        return getCfgItem(api, basicConfigEnum, configObjId, null, null, commonFlag);
    }

    /**
     * 读取购方业务配置项
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @param limiters        配置匹配条件
     * @param commonFlag
     * @return
     */
    @Deprecated
    public static BizTemplateDetail.CfgItem getCfgItem(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlag) {
        return getCfgItem(api, ConfigTypeEnum.PURCHASER, basicConfigEnum, configObjId, null, billTypeName, limiters, commonFlag);
    }

    /**
     * 读取购方业务配置项
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @param limiters        配置匹配条件
     * @param commonFlag
     * @return
     */
    @Deprecated
    public static BizTemplateDetail.CfgItem getCfgItem(BizTemplateConfigApi api, IBasicConfigEnum basicConfigEnum, Long configObjId, Map<String, Object> limiters, CommonFlagEnum commonFlag) {
        return getCfgItem(api, ConfigTypeEnum.PURCHASER, basicConfigEnum, configObjId, null, null, limiters, commonFlag);
    }

    /**
     * 读取业务配置项
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @param limiters        配置匹配条件
     * @param commonFlag
     * @return
     */
    @Deprecated
    public static BizTemplateDetail.CfgItem getCfgItem(BizTemplateConfigApi api, ConfigTypeEnum configtype, IBasicConfigEnum basicConfigEnum, Long configObjId, Long bindObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlag) {
        try {
            BaseResult<BizTemplateDetail> response = getBizDetail(api, configtype, basicConfigEnum, configObjId, bindObjId, billTypeName, limiters, commonFlag);
            log.info("##### 读取业务配置项,接口响应：{}", JsonUtils.writeObjectToFastJson(response));
            if (ResultCode.SUCCESS.code().equals(response.getCode()) && null != response.getResult() && !response.getResult().getCfgItems().isEmpty()) {
                BizTemplateDetail.CfgItem cfgItem = response.getResult().getCfgItems().get(0);
                return cfgItem;
            }
        } catch (Exception e) {
            log.warn("##### 租户ID:{}；模板modelType:{}读取配置异常：{}", configObjId, basicConfigEnum.modelType(), e);
        }
        return null;
    }

    /**
     * 读取业务配置项 支持单据类型
     *
     * @param api
     * @param basicConfigEnum
     * @param configObjId
     * @param limiters        配置匹配条件
     * @param commonFlag
     * @return
     */
    @Deprecated
    public static BaseResult<BizTemplateDetail> getBizDetail(BizTemplateConfigApi api, ConfigTypeEnum configType, IBasicConfigEnum basicConfigEnum, Long configObjId, Long bindObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlag) {
        // 模板modelType
        Integer modelType = basicConfigEnum.modelType();
        GetBizTemplateDetail request = new GetBizTemplateDetail();
        request.setConfigType(configType.code());
        request.setBindObjId(bindObjId);
        request.setConfigObjId(configObjId);
        request.setCommonFlag(commonFlag.code().toString());
        request.setModelType(modelType);
        request.setBillTypeName(billTypeName);
        try {
            // 字段过滤
            GetBizTemplateDetail.ComplexParam complexParam = new GetBizTemplateDetail.ComplexParam();
            if (!"ALL".equals(basicConfigEnum.code())) {
                complexParam.setFields(Arrays.asList(basicConfigEnum.code()));
            }
            if (!CollectionUtils.isEmpty(limiters)) {
                complexParam.setLimiters(limiters);
            }
            request.setComplexParam(complexParam);
            BaseResult<BizTemplateDetail> response = getBizDetail(api, request);
            log.info("##### 读取业务配置项,接口响应：{}", JsonUtils.writeObjectToFastJson(response));
            return response;
        } catch (Exception e) {
            log.warn("##### 租户ID:{}；模板modelType:{}读取配置异常：{}", configObjId, basicConfigEnum.modelType(), e);
        }
        return null;
    }

    /**
     * 读取业务配置
     *
     * @param api
     * @param request
     * @return
     */
    @Deprecated
    public static BaseResult<BizTemplateDetail> getBizDetail(BizTemplateConfigApi api, GetBizTemplateDetail request) {
        return api.getBizDetailPost(request);
    }

}