package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 税盘抽取订阅信息
 */
@ApiModel(description = "税盘抽取订阅信息")

@JsonInclude(NON_NULL)
public class SubscribeExtractInfo {
  @JsonProperty("extractValue")
  private String extractValue = null;

  @JsonProperty("extractType")
  private Integer extractType = null;

  @JsonIgnore
  public SubscribeExtractInfo extractValue(String extractValue) {
    this.extractValue = extractValue;
    return this;
  }

   /**
   * 类型值：抵账传税号，税盘传设备ID
   * @return extractValue
  **/
  @ApiModelProperty(value = "类型值：抵账传税号，税盘传设备ID")
  public String getExtractValue() {
    return extractValue;
  }

  public void setExtractValue(String extractValue) {
    this.extractValue = extractValue;
  }

  @JsonIgnore
  public SubscribeExtractInfo extractType(Integer extractType) {
    this.extractType = extractType;
    return this;
  }

   /**
   * 抽取类型：1【抵账】2【税盘】
   * @return extractType
  **/
  @ApiModelProperty(value = "抽取类型：1【抵账】2【税盘】")
  public Integer getExtractType() {
    return extractType;
  }

  public void setExtractType(Integer extractType) {
    this.extractType = extractType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscribeExtractInfo subscribeExtractInfo = (SubscribeExtractInfo) o;
    return Objects.equals(this.extractValue, subscribeExtractInfo.extractValue) &&
        Objects.equals(this.extractType, subscribeExtractInfo.extractType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(extractValue, extractType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscribeExtractInfo {\n");

    sb.append("    extractValue: ").append(toIndentedString(extractValue)).append("\n");
    sb.append("    extractType: ").append(toIndentedString(extractType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
