package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 更新设备信息
 */
@ApiModel(description = "更新设备信息")

@JsonInclude(NON_NULL)
public class UpdateDeviceInfo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("service")
  private List<String> service = new ArrayList<String>();

  @JsonProperty("taxDeviceInfo")
  private TaxDeviceInfo taxDeviceInfo = null;

  @JsonProperty("extraInfo")
  private DeviceExtraInfo extraInfo = null;

  @JsonIgnore
  public UpdateDeviceInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 设备id
   * @return id
  **/
  @ApiModelProperty(value = "设备id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateDeviceInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/
  @ApiModelProperty(value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/
  @ApiModelProperty(value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public UpdateDeviceInfo deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * (必须)设备类型，taxDevice：税控设备，UKey：UKey
   * @return deviceType
  **/
  @ApiModelProperty(value = "(必须)设备类型，taxDevice：税控设备，UKey：UKey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public UpdateDeviceInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public UpdateDeviceInfo service(List<String> service) {
    this.service = service;
    return this;
  }

  public UpdateDeviceInfo addServiceItem(String serviceItem) {
    this.service.add(serviceItem);
    return this;
  }

   /**
   * 支持的服务 （make：开票 ，print：打印，originAccount：底账）
   * @return service
  **/
  @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账）")
  public List<String> getService() {
    return service;
  }

  public void setService(List<String> service) {
    this.service = service;
  }

  @JsonIgnore
  public UpdateDeviceInfo taxDeviceInfo(TaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
    return this;
  }

   /**
   * 税控设备消息
   * @return taxDeviceInfo
  **/
  @ApiModelProperty(value = "税控设备消息")
  public TaxDeviceInfo getTaxDeviceInfo() {
    return taxDeviceInfo;
  }

  public void setTaxDeviceInfo(TaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
  }

  @JsonIgnore
  public UpdateDeviceInfo extraInfo(DeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
    return this;
  }

   /**
   * 配置信息
   * @return extraInfo
  **/
  @ApiModelProperty(value = "配置信息")
  public DeviceExtraInfo getExtraInfo() {
    return extraInfo;
  }

  public void setExtraInfo(DeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateDeviceInfo updateDeviceInfo = (UpdateDeviceInfo) o;
    return Objects.equals(this.id, updateDeviceInfo.id) &&
        Objects.equals(this.operateInfo, updateDeviceInfo.operateInfo) &&
        Objects.equals(this.deviceNo, updateDeviceInfo.deviceNo) &&
        Objects.equals(this.deviceName, updateDeviceInfo.deviceName) &&
        Objects.equals(this.deviceType, updateDeviceInfo.deviceType) &&
        Objects.equals(this.remark, updateDeviceInfo.remark) &&
        Objects.equals(this.service, updateDeviceInfo.service) &&
        Objects.equals(this.taxDeviceInfo, updateDeviceInfo.taxDeviceInfo) &&
        Objects.equals(this.extraInfo, updateDeviceInfo.extraInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, operateInfo, deviceNo, deviceName, deviceType, remark, service, taxDeviceInfo, extraInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateDeviceInfo {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
    sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
