package com.xforceplus.ant.coop.rule.center.client.data.enterprise.response;

import java.io.Serializable;

/**
 * 设备发票信息
 */
public class DeviceInvoiceInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  /** 发票类型 */
  private String invoiceType = null;
  /** 总离线时长，单位小时 */
  private Integer offlineTime = null;
  /** 剩余离线时长，单位小时 -1="未知" ， >=0 为正常值 */
  private Integer leftOfflineTime = null;
  /** 总离线金额，精度是2位小数	  -1="未知" */
  private String offlineAmount = null;
  /** 剩余离线金额，精度是2位小数	-1="未知" */
  private String leftOfflineAmount = null;
  /** 发票限额，精度是2位小数 */
  private String limitAmount = null;
  /** 空白发票数量，单位：张 */
  private Integer leftBlankInvoices = null;
  /** 最近一次抄报汇总日期   yyyyMMdd */
  private String lastReportDate = null;
  /** 清卡截至日期，过期后税盘锁死不能开票，之后需要到税局解锁 */
  private String lockDate = null;


  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  public Integer getOfflineTime() {
    return offlineTime;
  }

  public void setOfflineTime(Integer offlineTime) {
    this.offlineTime = offlineTime;
  }

  public Integer getLeftOfflineTime() {
    return leftOfflineTime;
  }

  public void setLeftOfflineTime(Integer leftOfflineTime) {
    this.leftOfflineTime = leftOfflineTime;
  }

  public String getOfflineAmount() {
    return offlineAmount;
  }

  public void setOfflineAmount(String offlineAmount) {
    this.offlineAmount = offlineAmount;
  }

  public String getLeftOfflineAmount() {
    return leftOfflineAmount;
  }

  public void setLeftOfflineAmount(String leftOfflineAmount) {
    this.leftOfflineAmount = leftOfflineAmount;
  }

  public String getLimitAmount() {
    return limitAmount;
  }

  public void setLimitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
  }

  public Integer getLeftBlankInvoices() {
    return leftBlankInvoices;
  }

  public void setLeftBlankInvoices(Integer leftBlankInvoices) {
    this.leftBlankInvoices = leftBlankInvoices;
  }

  public String getLastReportDate() {
    return lastReportDate;
  }

  public void setLastReportDate(String lastReportDate) {
    this.lastReportDate = lastReportDate;
  }

  public String getLockDate() {
    return lockDate;
  }

  public void setLockDate(String lockDate) {
    this.lockDate = lockDate;
  }

}
