package com.xforceplus.ant.coop.rule.center.client.data.sc.menu;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 树形菜单列表
 *
 * @Author xiezhongyong
 * @Date 2022-05-05
 */
@Data
public class ListTreeMenu {

    @ApiModelProperty("菜单ID")
    private String id;

    @ApiModelProperty("父菜单ID")
    private String parentMenuId;

    @ApiModelProperty("菜单类型; 1-普通菜单(默认) 2-配置菜单(没有下级菜单,支持查询模板列表)")
    private Integer menuType;

    @ApiModelProperty("菜单名称")
    private String menuName;

    @ApiModelProperty("菜单描述")
    private String menuDesc;

    @ApiModelProperty("级联菜单ID列表(勾选时需要级联勾选的菜单ID)")
    private String cascadeMenuIds;

    @ApiModelProperty("默认显示;1-显示(默认) 0:不显示")
    private Integer defaultShow;

    @ApiModelProperty("编辑标记;0-可以勾选和删除 1-可勾选不能删除")
    private Integer editFlag;

    @ApiModelProperty("是否选择(true-已选择 false-未选择)")
    private Boolean checked = Boolean.FALSE;

    @ApiModelProperty("子菜单")
    private List<ListTreeMenu> childList = new ArrayList<>();
}
