package com.xforceplus.ant.coop.rule.center.client.data.utils;

import com.xforceplus.ant.coop.rule.center.client.model.MsResponse;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * Describe: 接口响应
 * @Author xiezhongyong
 * @Date 2019-12-10
 * @Version 1.0
 */
@Data
public class BaseResult<T> implements Serializable {

    /** 返回结果状态码 */
    @ApiModelProperty("状态码")
    private Integer code;

    /** 返回提示信息 */
    @ApiModelProperty("提示信息")
    private String message;

    /** 返回成功数据 */
    @ApiModelProperty("响应数据")
    private T result;

    @ApiModelProperty("请求ID")
    private String requestId;


    public static final BaseResult<String> SUCCESS = new BaseResult<>(ResultCode.SUCCESS);

    /**
     * 静态方法
     */
    public static BaseResult<String> success() {
        return new BaseResult<>();
    }

    public static <T> BaseResult<T> success(T t) {
        return new BaseResult<>(t);
    }

    public static BaseResult<String> error() {
        return new BaseResult<>(ResultCode.SYSTEM_INNER_ERROR);
    }

    public static BaseResult<String> error(ResultCode resultCodeEnum) {
        return new BaseResult<>(resultCodeEnum);
    }

    public static <T> BaseResult<T> fail(String message) {
        return new BaseResult<>(message);
    }
    /**
     * 构造函数
     */
    private BaseResult() {
        this(ResultCode.SUCCESS);
    }

    private BaseResult(T t) {
        this(ResultCode.SUCCESS, t);
    }

    private BaseResult(String message) {
        this(Response.Fail,message);
    }

    private BaseResult(ResultCode resultCode) {
        this(resultCode, null);
    }

    private BaseResult(ResultCode resultCode, T t) {
        this(resultCode.code(), resultCode.message(), t);
    }

    public BaseResult(int code, String message) {
        this(code, message, null);
    }

    private BaseResult(int code, String message, T t) {
        this.code = code;
        this.message = message;
        this.result = t;
    }
}
