package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformLogo;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformServerCall;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台配置信息
 */
@ApiModel(description = "平台配置信息")

@JsonInclude(NON_NULL)
public class MsGetPlatformConfigBySource {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("personsCenterStatus")
  private Integer personsCenterStatus = null;

  @JsonProperty("personsCenterModuleId")
  private String personsCenterModuleId = null;

  @JsonProperty("dynamicModule1Id")
  private String dynamicModule1Id = null;

  @JsonProperty("dynamicModule2Id")
  private String dynamicModule2Id = null;

  @JsonProperty("advertiseSite1Id")
  private String advertiseSite1Id = null;

  @JsonProperty("serviceModuleId")
  private String serviceModuleId = null;

  @JsonProperty("userPermissionStatus")
  private Integer userPermissionStatus = null;

  @JsonProperty("platformLogos")
  private List<MsGetPlatformLogo> platformLogos = new ArrayList<MsGetPlatformLogo>();

  @JsonProperty("platformServerCalls")
  private List<MsGetPlatformServerCall> platformServerCalls = new ArrayList<MsGetPlatformServerCall>();

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsGetPlatformConfigBySource id(String id) {
    this.id = id;
    return this;
  }

   /**
   * 平台配置ID
   * @return id
  **/
  @ApiModelProperty(value = "平台配置ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource personsCenterStatus(Integer personsCenterStatus) {
    this.personsCenterStatus = personsCenterStatus;
    return this;
  }

   /**
   * 个人中心展示状态  0-不展示  1-展示
   * @return personsCenterStatus
  **/
  @ApiModelProperty(value = "个人中心展示状态  0-不展示  1-展示")
  public Integer getPersonsCenterStatus() {
    return personsCenterStatus;
  }

  public void setPersonsCenterStatus(Integer personsCenterStatus) {
    this.personsCenterStatus = personsCenterStatus;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource personsCenterModuleId(String personsCenterModuleId) {
    this.personsCenterModuleId = personsCenterModuleId;
    return this;
  }

   /**
   * 个人中心组件ID
   * @return personsCenterModuleId
  **/
  @ApiModelProperty(value = "个人中心组件ID")
  public String getPersonsCenterModuleId() {
    return personsCenterModuleId;
  }

  public void setPersonsCenterModuleId(String personsCenterModuleId) {
    this.personsCenterModuleId = personsCenterModuleId;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource dynamicModule1Id(String dynamicModule1Id) {
    this.dynamicModule1Id = dynamicModule1Id;
    return this;
  }

   /**
   * 动态模块1 ID
   * @return dynamicModule1Id
  **/
  @ApiModelProperty(value = "动态模块1 ID")
  public String getDynamicModule1Id() {
    return dynamicModule1Id;
  }

  public void setDynamicModule1Id(String dynamicModule1Id) {
    this.dynamicModule1Id = dynamicModule1Id;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource dynamicModule2Id(String dynamicModule2Id) {
    this.dynamicModule2Id = dynamicModule2Id;
    return this;
  }

   /**
   * 动态模块2 ID
   * @return dynamicModule2Id
  **/
  @ApiModelProperty(value = "动态模块2 ID")
  public String getDynamicModule2Id() {
    return dynamicModule2Id;
  }

  public void setDynamicModule2Id(String dynamicModule2Id) {
    this.dynamicModule2Id = dynamicModule2Id;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource advertiseSite1Id(String advertiseSite1Id) {
    this.advertiseSite1Id = advertiseSite1Id;
    return this;
  }

   /**
   * 广告位右1 ID
   * @return advertiseSite1Id
  **/
  @ApiModelProperty(value = "广告位右1 ID")
  public String getAdvertiseSite1Id() {
    return advertiseSite1Id;
  }

  public void setAdvertiseSite1Id(String advertiseSite1Id) {
    this.advertiseSite1Id = advertiseSite1Id;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource serviceModuleId(String serviceModuleId) {
    this.serviceModuleId = serviceModuleId;
    return this;
  }

   /**
   * 客服组件 ID
   * @return serviceModuleId
  **/
  @ApiModelProperty(value = "客服组件 ID")
  public String getServiceModuleId() {
    return serviceModuleId;
  }

  public void setServiceModuleId(String serviceModuleId) {
    this.serviceModuleId = serviceModuleId;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource userPermissionStatus(Integer userPermissionStatus) {
    this.userPermissionStatus = userPermissionStatus;
    return this;
  }

   /**
   * 用户权限状态  0-不展示(默认)  1-展示
   * @return userPermissionStatus
  **/
  @ApiModelProperty(value = "用户权限状态  0-不展示(默认)  1-展示")
  public Integer getUserPermissionStatus() {
    return userPermissionStatus;
  }

  public void setUserPermissionStatus(Integer userPermissionStatus) {
    this.userPermissionStatus = userPermissionStatus;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource platformLogos(List<MsGetPlatformLogo> platformLogos) {
    this.platformLogos = platformLogos;
    return this;
  }

  public MsGetPlatformConfigBySource addPlatformLogosItem(MsGetPlatformLogo platformLogosItem) {
    this.platformLogos.add(platformLogosItem);
    return this;
  }

   /**
   * logo 列表
   * @return platformLogos
  **/
  @ApiModelProperty(value = "logo 列表")
  public List<MsGetPlatformLogo> getPlatformLogos() {
    return platformLogos;
  }

  public void setPlatformLogos(List<MsGetPlatformLogo> platformLogos) {
    this.platformLogos = platformLogos;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource platformServerCalls(List<MsGetPlatformServerCall> platformServerCalls) {
    this.platformServerCalls = platformServerCalls;
    return this;
  }

  public MsGetPlatformConfigBySource addPlatformServerCallsItem(MsGetPlatformServerCall platformServerCallsItem) {
    this.platformServerCalls.add(platformServerCallsItem);
    return this;
  }

   /**
   * 平台服务调用 列表
   * @return platformServerCalls
  **/
  @ApiModelProperty(value = "平台服务调用 列表")
  public List<MsGetPlatformServerCall> getPlatformServerCalls() {
    return platformServerCalls;
  }

  public void setPlatformServerCalls(List<MsGetPlatformServerCall> platformServerCalls) {
    this.platformServerCalls = platformServerCalls;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySource updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPlatformConfigBySource getPlatformConfigBySource = (MsGetPlatformConfigBySource) o;
    return Objects.equals(this.id, getPlatformConfigBySource.id) &&
        Objects.equals(this.personsCenterStatus, getPlatformConfigBySource.personsCenterStatus) &&
        Objects.equals(this.personsCenterModuleId, getPlatformConfigBySource.personsCenterModuleId) &&
        Objects.equals(this.dynamicModule1Id, getPlatformConfigBySource.dynamicModule1Id) &&
        Objects.equals(this.dynamicModule2Id, getPlatformConfigBySource.dynamicModule2Id) &&
        Objects.equals(this.advertiseSite1Id, getPlatformConfigBySource.advertiseSite1Id) &&
        Objects.equals(this.serviceModuleId, getPlatformConfigBySource.serviceModuleId) &&
        Objects.equals(this.userPermissionStatus, getPlatformConfigBySource.userPermissionStatus) &&
        Objects.equals(this.platformLogos, getPlatformConfigBySource.platformLogos) &&
        Objects.equals(this.platformServerCalls, getPlatformConfigBySource.platformServerCalls) &&
        Objects.equals(this.createTime, getPlatformConfigBySource.createTime) &&
        Objects.equals(this.updateTime, getPlatformConfigBySource.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, personsCenterStatus, personsCenterModuleId, dynamicModule1Id, dynamicModule2Id, advertiseSite1Id, serviceModuleId, userPermissionStatus, platformLogos, platformServerCalls, createTime, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPlatformConfigBySource {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    personsCenterStatus: ").append(toIndentedString(personsCenterStatus)).append("\n");
    sb.append("    personsCenterModuleId: ").append(toIndentedString(personsCenterModuleId)).append("\n");
    sb.append("    dynamicModule1Id: ").append(toIndentedString(dynamicModule1Id)).append("\n");
    sb.append("    dynamicModule2Id: ").append(toIndentedString(dynamicModule2Id)).append("\n");
    sb.append("    advertiseSite1Id: ").append(toIndentedString(advertiseSite1Id)).append("\n");
    sb.append("    serviceModuleId: ").append(toIndentedString(serviceModuleId)).append("\n");
    sb.append("    userPermissionStatus: ").append(toIndentedString(userPermissionStatus)).append("\n");
    sb.append("    platformLogos: ").append(toIndentedString(platformLogos)).append("\n");
    sb.append("    platformServerCalls: ").append(toIndentedString(platformServerCalls)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
