package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台logo信息
 */
@ApiModel(description = "平台logo信息")

@JsonInclude(NON_NULL)
public class MsGetPlatformLogo {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("logoUrl")
  private String logoUrl = null;

  @JsonProperty("logoLink")
  private String logoLink = null;

  @JsonProperty("defaultFlag")
  private Integer defaultFlag = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("sort")
  private Integer sort = null;

  @JsonIgnore
  public MsGetPlatformLogo id(String id) {
    this.id = id;
    return this;
  }

   /**
   * logo 数据ID
   * @return id
  **/
  @ApiModelProperty(value = "logo 数据ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetPlatformLogo logoUrl(String logoUrl) {
    this.logoUrl = logoUrl;
    return this;
  }

   /**
   * logo 地址
   * @return logoUrl
  **/
  @ApiModelProperty(value = "logo 地址")
  public String getLogoUrl() {
    return logoUrl;
  }

  public void setLogoUrl(String logoUrl) {
    this.logoUrl = logoUrl;
  }

  @JsonIgnore
  public MsGetPlatformLogo logoLink(String logoLink) {
    this.logoLink = logoLink;
    return this;
  }

   /**
   * logo 链接
   * @return logoLink
  **/
  @ApiModelProperty(value = "logo 链接")
  public String getLogoLink() {
    return logoLink;
  }

  public void setLogoLink(String logoLink) {
    this.logoLink = logoLink;
  }

  @JsonIgnore
  public MsGetPlatformLogo defaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
    return this;
  }

   /**
   * 默认标记(标记当前logo是否为默认/票易通logo)  0-非默认标记(默认) 1-默认
   * @return defaultFlag
  **/
  @ApiModelProperty(value = "默认标记(标记当前logo是否为默认/票易通logo)  0-非默认标记(默认) 1-默认")
  public Integer getDefaultFlag() {
    return defaultFlag;
  }

  public void setDefaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
  }

  @JsonIgnore
  public MsGetPlatformLogo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * logo状态  0-启用(默认) 1-停用
   * @return status
  **/
  @ApiModelProperty(value = "logo状态  0-启用(默认) 1-停用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetPlatformLogo sort(Integer sort) {
    this.sort = sort;
    return this;
  }

   /**
   * 排序值
   * @return sort
  **/
  @ApiModelProperty(value = "排序值")
  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPlatformLogo getPlatformLogo = (MsGetPlatformLogo) o;
    return Objects.equals(this.id, getPlatformLogo.id) &&
        Objects.equals(this.logoUrl, getPlatformLogo.logoUrl) &&
        Objects.equals(this.logoLink, getPlatformLogo.logoLink) &&
        Objects.equals(this.defaultFlag, getPlatformLogo.defaultFlag) &&
        Objects.equals(this.status, getPlatformLogo.status) &&
        Objects.equals(this.sort, getPlatformLogo.sort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, logoUrl, logoLink, defaultFlag, status, sort);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPlatformLogo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    logoUrl: ").append(toIndentedString(logoUrl)).append("\n");
    sb.append("    logoLink: ").append(toIndentedString(logoLink)).append("\n");
    sb.append("    defaultFlag: ").append(toIndentedString(defaultFlag)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
