package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.coop.rule.center.client.model.MsUpdatePlatformLogo;
import com.xforceplus.ant.coop.rule.center.client.model.MsUpdatePlatformServerCall;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台配置信息
 */
@ApiModel(description = "平台配置信息")

@JsonInclude(NON_NULL)
public class MsUpdatePlatformConfigRequest {
  @JsonProperty("personsCenterStatus")
  private Integer personsCenterStatus = null;

  @JsonProperty("personsCenterModuleId")
  private String personsCenterModuleId = null;

  @JsonProperty("dynamicModule1Id")
  private String dynamicModule1Id = null;

  @JsonProperty("dynamicModule2Id")
  private String dynamicModule2Id = null;

  @JsonProperty("advertiseSite1Id")
  private String advertiseSite1Id = null;

  @JsonProperty("serviceModuleId")
  private String serviceModuleId = null;

  @JsonProperty("userPermissionStatus")
  private Integer userPermissionStatus = null;

  @JsonProperty("platformLogos")
  private List<MsUpdatePlatformLogo> platformLogos = new ArrayList<MsUpdatePlatformLogo>();

  @JsonProperty("platformServerCalls")
  private List<MsUpdatePlatformServerCall> platformServerCalls = new ArrayList<MsUpdatePlatformServerCall>();

  @JsonIgnore
  public MsUpdatePlatformConfigRequest personsCenterStatus(Integer personsCenterStatus) {
    this.personsCenterStatus = personsCenterStatus;
    return this;
  }

   /**
   * 个人中心展示状态  0-不展示  1-展示
   * @return personsCenterStatus
  **/
  @ApiModelProperty(value = "个人中心展示状态  0-不展示  1-展示")
  public Integer getPersonsCenterStatus() {
    return personsCenterStatus;
  }

  public void setPersonsCenterStatus(Integer personsCenterStatus) {
    this.personsCenterStatus = personsCenterStatus;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest personsCenterModuleId(String personsCenterModuleId) {
    this.personsCenterModuleId = personsCenterModuleId;
    return this;
  }

   /**
   * 个人中心组件ID
   * @return personsCenterModuleId
  **/
  @ApiModelProperty(value = "个人中心组件ID")
  public String getPersonsCenterModuleId() {
    return personsCenterModuleId;
  }

  public void setPersonsCenterModuleId(String personsCenterModuleId) {
    this.personsCenterModuleId = personsCenterModuleId;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest dynamicModule1Id(String dynamicModule1Id) {
    this.dynamicModule1Id = dynamicModule1Id;
    return this;
  }

   /**
   * 动态模块1 ID
   * @return dynamicModule1Id
  **/
  @ApiModelProperty(value = "动态模块1 ID")
  public String getDynamicModule1Id() {
    return dynamicModule1Id;
  }

  public void setDynamicModule1Id(String dynamicModule1Id) {
    this.dynamicModule1Id = dynamicModule1Id;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest dynamicModule2Id(String dynamicModule2Id) {
    this.dynamicModule2Id = dynamicModule2Id;
    return this;
  }

   /**
   * 动态模块2 ID
   * @return dynamicModule2Id
  **/
  @ApiModelProperty(value = "动态模块2 ID")
  public String getDynamicModule2Id() {
    return dynamicModule2Id;
  }

  public void setDynamicModule2Id(String dynamicModule2Id) {
    this.dynamicModule2Id = dynamicModule2Id;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest advertiseSite1Id(String advertiseSite1Id) {
    this.advertiseSite1Id = advertiseSite1Id;
    return this;
  }

   /**
   * 广告位右1 ID
   * @return advertiseSite1Id
  **/
  @ApiModelProperty(value = "广告位右1 ID")
  public String getAdvertiseSite1Id() {
    return advertiseSite1Id;
  }

  public void setAdvertiseSite1Id(String advertiseSite1Id) {
    this.advertiseSite1Id = advertiseSite1Id;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest serviceModuleId(String serviceModuleId) {
    this.serviceModuleId = serviceModuleId;
    return this;
  }

   /**
   * 客服组件 ID
   * @return serviceModuleId
  **/
  @ApiModelProperty(value = "客服组件 ID")
  public String getServiceModuleId() {
    return serviceModuleId;
  }

  public void setServiceModuleId(String serviceModuleId) {
    this.serviceModuleId = serviceModuleId;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest userPermissionStatus(Integer userPermissionStatus) {
    this.userPermissionStatus = userPermissionStatus;
    return this;
  }

   /**
   * 用户权限状态  0-不展示(默认)  1-展示
   * @return userPermissionStatus
  **/
  @ApiModelProperty(value = "用户权限状态  0-不展示(默认)  1-展示")
  public Integer getUserPermissionStatus() {
    return userPermissionStatus;
  }

  public void setUserPermissionStatus(Integer userPermissionStatus) {
    this.userPermissionStatus = userPermissionStatus;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest platformLogos(List<MsUpdatePlatformLogo> platformLogos) {
    this.platformLogos = platformLogos;
    return this;
  }

  public MsUpdatePlatformConfigRequest addPlatformLogosItem(MsUpdatePlatformLogo platformLogosItem) {
    this.platformLogos.add(platformLogosItem);
    return this;
  }

   /**
   * logo 列表
   * @return platformLogos
  **/
  @ApiModelProperty(value = "logo 列表")
  public List<MsUpdatePlatformLogo> getPlatformLogos() {
    return platformLogos;
  }

  public void setPlatformLogos(List<MsUpdatePlatformLogo> platformLogos) {
    this.platformLogos = platformLogos;
  }

  @JsonIgnore
  public MsUpdatePlatformConfigRequest platformServerCalls(List<MsUpdatePlatformServerCall> platformServerCalls) {
    this.platformServerCalls = platformServerCalls;
    return this;
  }

  public MsUpdatePlatformConfigRequest addPlatformServerCallsItem(MsUpdatePlatformServerCall platformServerCallsItem) {
    this.platformServerCalls.add(platformServerCallsItem);
    return this;
  }

   /**
   * 平台服务调用 列表
   * @return platformServerCalls
  **/
  @ApiModelProperty(value = "平台服务调用 列表")
  public List<MsUpdatePlatformServerCall> getPlatformServerCalls() {
    return platformServerCalls;
  }

  public void setPlatformServerCalls(List<MsUpdatePlatformServerCall> platformServerCalls) {
    this.platformServerCalls = platformServerCalls;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdatePlatformConfigRequest updatePlatformConfigRequest = (MsUpdatePlatformConfigRequest) o;
    return Objects.equals(this.personsCenterStatus, updatePlatformConfigRequest.personsCenterStatus) &&
        Objects.equals(this.personsCenterModuleId, updatePlatformConfigRequest.personsCenterModuleId) &&
        Objects.equals(this.dynamicModule1Id, updatePlatformConfigRequest.dynamicModule1Id) &&
        Objects.equals(this.dynamicModule2Id, updatePlatformConfigRequest.dynamicModule2Id) &&
        Objects.equals(this.advertiseSite1Id, updatePlatformConfigRequest.advertiseSite1Id) &&
        Objects.equals(this.serviceModuleId, updatePlatformConfigRequest.serviceModuleId) &&
        Objects.equals(this.userPermissionStatus, updatePlatformConfigRequest.userPermissionStatus) &&
        Objects.equals(this.platformLogos, updatePlatformConfigRequest.platformLogos) &&
        Objects.equals(this.platformServerCalls, updatePlatformConfigRequest.platformServerCalls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(personsCenterStatus, personsCenterModuleId, dynamicModule1Id, dynamicModule2Id, advertiseSite1Id, serviceModuleId, userPermissionStatus, platformLogos, platformServerCalls);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdatePlatformConfigRequest {\n");
    
    sb.append("    personsCenterStatus: ").append(toIndentedString(personsCenterStatus)).append("\n");
    sb.append("    personsCenterModuleId: ").append(toIndentedString(personsCenterModuleId)).append("\n");
    sb.append("    dynamicModule1Id: ").append(toIndentedString(dynamicModule1Id)).append("\n");
    sb.append("    dynamicModule2Id: ").append(toIndentedString(dynamicModule2Id)).append("\n");
    sb.append("    advertiseSite1Id: ").append(toIndentedString(advertiseSite1Id)).append("\n");
    sb.append("    serviceModuleId: ").append(toIndentedString(serviceModuleId)).append("\n");
    sb.append("    userPermissionStatus: ").append(toIndentedString(userPermissionStatus)).append("\n");
    sb.append("    platformLogos: ").append(toIndentedString(platformLogos)).append("\n");
    sb.append("    platformServerCalls: ").append(toIndentedString(platformServerCalls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
