/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.rule.center.client.data.cc.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.api.cc.BizConfigOpenApi;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.BizMainConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.BizConfigTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.CommonFlagEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.ConfigTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg.IBasicConfigEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.GetBizConfigDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.BizConfigDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BizConfigTool {
    private static final Logger log = LoggerFactory.getLogger(BizConfigTool.class);

    public static <T> T getBizConfigDetail(BizConfigOpenApi api, ConfigTypeEnum configType, IBasicConfigEnum basicConfigEnum, Long configObjId) {
        return BizConfigTool.getBizConfigDetail(api, configType, basicConfigEnum, configObjId, null, null);
    }

    public static <T> T getBizConfigDetail(BizConfigOpenApi api, ConfigTypeEnum configType, IBasicConfigEnum basicConfigEnum, Long configObjId, String sellerTaxNo, String purchaserTaxNo) {
        return BizConfigTool.getBizConfigDetail(api, configType, basicConfigEnum, configObjId, null, null, null, CommonFlagEnum.ACCEPT, sellerTaxNo, purchaserTaxNo);
    }

    public static <T> T getBizConfigDetail(BizConfigOpenApi api, ConfigTypeEnum configType, IBasicConfigEnum basicConfigEnum, Long configObjId, Long bindObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlag) {
        return BizConfigTool.getBizConfigDetail(api, configType, basicConfigEnum, configObjId, bindObjId, billTypeName, limiters, commonFlag, null, null);
    }

    public static <T> T getBizConfigDetail(BizConfigOpenApi api, ConfigTypeEnum configType, IBasicConfigEnum basicConfigEnum, Long configObjId, Long bindObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlag, String sellerTaxNo, String purchaserTaxNo) {
        try {
            BaseResult<BizConfigDetail> response = BizConfigTool.getBizConfigResponse(api, configType, basicConfigEnum.modelType(), basicConfigEnum.code(), configObjId, bindObjId, billTypeName, limiters, commonFlag, sellerTaxNo, purchaserTaxNo);
            BizConfigDetail result = response.getResult();
            if (ResultCode.SUCCESS.code().equals(response.getCode()) && null != result) {
                return BizConfigTool.getConfig(result);
            }
            log.warn("##### \u8bfb\u53d6\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\u6216\u8005\u672a\u627e\u5230\u914d\u7f6e,\u54cd\u5e94\u5185\u5bb9: {}", response);
            return null;
        }
        catch (Exception e) {
            log.warn("##### \u79df\u6237ID:{}\uff1b\u6a21\u677fmodelType:{}\u8bfb\u53d6\u914d\u7f6e\u5f02\u5e38\uff1a{}", new Object[]{configObjId, basicConfigEnum.modelType(), e});
            return null;
        }
    }

    public static BaseResult<BizConfigDetail> getBizConfigResponse(BizConfigOpenApi api, ConfigTypeEnum configType, Integer modelType, String configCode, Long configObjId, Long bindObjId, String billTypeName, Map<String, Object> limiters, CommonFlagEnum commonFlag, String sellerTaxNo, String purchaserTaxNo) {
        GetBizConfigDetail request = new GetBizConfigDetail();
        request.setConfigType(configType.code());
        request.setBindObjId(bindObjId);
        request.setConfigObjId(configObjId);
        if (null != commonFlag) {
            request.setCommonFlag(commonFlag.code().toString());
        }
        request.setModelType(modelType);
        request.setBillTypeName(billTypeName);
        request.setConfigCode(configCode);
        request.setSellerTaxNo(sellerTaxNo);
        request.setPurchaserTaxNo(purchaserTaxNo);
        try {
            GetBizConfigDetail.BizConfigComplexParam complexParam = new GetBizConfigDetail.BizConfigComplexParam();
            if (!CollectionUtils.isEmpty(limiters)) {
                complexParam.setLimiters(limiters);
            }
            request.setComplexParam(complexParam);
            log.info("##### \u8bfb\u53d6\u4e1a\u52a1\u914d\u7f6ebizconfig,\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)request));
            BaseResult<BizConfigDetail> response = BizConfigTool.getBizConfigResponse(api, request);
            log.info("##### \u8bfb\u53d6\u4e1a\u52a1\u914d\u7f6ebizconfig,\u63a5\u53e3\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)JsonUtils.writeObjectToFastJson(response));
            return response;
        }
        catch (Throwable e) {
            log.error("##### \u79df\u6237ID:{}\uff1b\u6a21\u677fmodelType:{}, configCode: {}, \u8bfb\u53d6\u4e1a\u52a1\u914d\u7f6ebizconfig\u5f02\u5e38\uff1a{}", new Object[]{configObjId, modelType, configCode, e});
            return null;
        }
    }

    public static BaseResult<BizConfigDetail> getBizConfigResponse(BizConfigOpenApi api, GetBizConfigDetail request) {
        return api.getBizConfigDetailPost(request);
    }

    public static <T> T getConfig(BizConfigDetail bizConfigDetail) {
        BizConfigTypeEnum configTypeEnum = BizConfigTypeEnum.fromValue(bizConfigDetail.getConfigType());
        if (StringUtils.isEmpty((Object)bizConfigDetail.getConfigResult())) {
            return null;
        }
        JSONObject configResult = bizConfigDetail.getConfigResult();
        BizConfig bizConfig = (BizConfig)JSON.parseObject((String)configResult.toJSONString(), (Class)configTypeEnum.configClass());
        bizConfig.setMainConfig((BizMainConfig)JSON.parseObject((String)JSON.toJSONString((Object)bizConfigDetail), BizMainConfig.class));
        log.info("##### \u4e1a\u52a1\u914d\u7f6e\u54cd\u5e94 \u8f6c\u6362\u4e3aBizConfig\u5bf9\u8c61\u540e\u5185\u5bb9: {}", (Object)bizConfig);
        return (T)bizConfig;
    }
}

