/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.rule.center.client.utils;

import com.xforceplus.ant.coop.rule.center.client.bean.FieldBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BeanUtil {
    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static void copyProperties(Object source, Object target) throws BeansException {
        Field[] targetFields;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        HashSet<FieldBean> fieldBeans = new HashSet<FieldBean>();
        HashMap targetFieldsMap = new HashMap(20);
        for (Field targetField : targetFields = target.getClass().getDeclaredFields()) {
            targetField.setAccessible(true);
            targetFieldsMap.put(targetField.getName(), targetField.getType());
        }
        Field[] sourceFields = source.getClass().getDeclaredFields();
        FieldBean fieldBean = null;
        String fieldName = null;
        for (Field sourceField : sourceFields) {
            sourceField.setAccessible(true);
            fieldName = sourceField.getName();
            if (fieldName == null || !targetFieldsMap.containsKey(fieldName)) continue;
            fieldBean = new FieldBean();
            fieldBean.setFieldName(fieldName);
            fieldBean.setGetterName(BeanUtil.getGetterOrSetterName(fieldName, "get"));
            fieldBean.setSetterName(BeanUtil.getGetterOrSetterName(fieldName, "set"));
            fieldBean.setGetterType(sourceField.getType());
            fieldBean.setSetterType((Class)targetFieldsMap.get(fieldName));
            fieldBeans.add(fieldBean);
        }
        BeanUtil.copyProperties(source, target, fieldBeans);
    }

    public static void copyPropertiesForNull(Object source, Object target, Object dbTarget, Set<FieldBean> fieldBeans) throws BeansException {
        HashSet<FieldBean> nullFieldBeans = new HashSet<FieldBean>();
        Iterator<FieldBean> iterator = fieldBeans.iterator();
        FieldBean fieldBean = null;
        while (iterator.hasNext()) {
            fieldBean = iterator.next();
            try {
                Integer integerValueSource;
                Integer integerValue;
                Method dbTargetMethod = dbTarget.getClass().getDeclaredMethod(fieldBean.getGetterName(), new Class[0]);
                Method sourceMethod = source.getClass().getDeclaredMethod(fieldBean.getGetterName(), new Class[0]);
                dbTargetMethod.setAccessible(true);
                sourceMethod.setAccessible(true);
                if (String.class.equals(fieldBean.getSetterType()) && String.class.equals(fieldBean.getGetterType())) {
                    if (!StringUtils.isEmpty((Object)dbTargetMethod.invoke(dbTarget, new Object[0])) || StringUtils.isEmpty((Object)sourceMethod.invoke(source, new Object[0]))) continue;
                    nullFieldBeans.add(fieldBean);
                    logger.info("\u53c2\u4e0e\u66f4\u65b0\u6743\u9650\u7684\u8986\u76d6\u62f7\u8d1d\uff0cfieldName:{}", (Object)fieldBean.getFieldName());
                    continue;
                }
                if (BigDecimal.class.equals(fieldBean.getSetterType()) && String.class.equals(fieldBean.getGetterType())) {
                    BigDecimal decimalValue = (BigDecimal)dbTargetMethod.invoke(dbTarget, new Object[0]);
                    if (decimalValue != null && BigDecimal.ZERO.compareTo(decimalValue) != 0 || StringUtils.isEmpty((Object)sourceMethod.invoke(source, new Object[0]))) continue;
                    nullFieldBeans.add(fieldBean);
                    logger.info("\u53c2\u4e0e\u66f4\u65b0\u6743\u9650\u7684\u8986\u76d6\u62f7\u8d1d\uff0cfieldName:{}", (Object)fieldBean.getFieldName());
                    continue;
                }
                if (Long.class.equals(fieldBean.getSetterType()) && Long.class.equals(fieldBean.getGetterType())) {
                    Long longValueSource;
                    Long longValue = (Long)dbTargetMethod.invoke(dbTarget, new Object[0]);
                    if (longValue != null && longValue.compareTo(0L) != 0 || (longValueSource = (Long)sourceMethod.invoke(source, new Object[0])) == null || longValueSource.compareTo(0L) == 0) continue;
                    nullFieldBeans.add(fieldBean);
                    logger.info("\u53c2\u4e0e\u66f4\u65b0\u6743\u9650\u7684\u8986\u76d6\u62f7\u8d1d\uff0cfieldName:{}", (Object)fieldBean.getFieldName());
                    continue;
                }
                if (!Integer.class.equals(fieldBean.getSetterType()) || !Integer.class.equals(fieldBean.getGetterType()) || (integerValue = (Integer)dbTargetMethod.invoke(dbTarget, new Object[0])) != null && integerValue.compareTo(0) != 0 || (integerValueSource = (Integer)sourceMethod.invoke(source, new Object[0])) == null || integerValueSource.compareTo(0) == 0) continue;
                nullFieldBeans.add(fieldBean);
                logger.info("\u53c2\u4e0e\u66f4\u65b0\u6743\u9650\u7684\u8986\u76d6\u62f7\u8d1d\uff0cfieldName:{}", (Object)fieldBean.getFieldName());
            }
            catch (Exception e) {
                logger.error("copyPropertiesForNull \u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        if (!CollectionUtils.isEmpty(nullFieldBeans)) {
            BeanUtil.copyProperties(source, target, nullFieldBeans);
        }
    }

    public static void copyProperties(Object source, Object target, Set<FieldBean> fieldBeans) throws BeansException {
        for (FieldBean fieldBean : fieldBeans) {
            try {
                Object sourceValue;
                Method targetMethod = target.getClass().getDeclaredMethod(fieldBean.getSetterName(), fieldBean.getSetterType());
                Method sourceMethod = source.getClass().getDeclaredMethod(fieldBean.getGetterName(), new Class[0]);
                targetMethod.setAccessible(true);
                sourceMethod.setAccessible(true);
                if (fieldBean.getSetterType().equals(fieldBean.getGetterType())) {
                    targetMethod.invoke(target, sourceMethod.invoke(source, new Object[0]));
                    continue;
                }
                if (Date.class.equals(fieldBean.getSetterType()) && String.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, new Date(Long.parseLong((String)sourceValue)));
                    continue;
                }
                if (Date.class.equals(fieldBean.getSetterType()) && Long.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (Long)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    targetMethod.invoke(target, new Date((Long)sourceValue));
                    continue;
                }
                if (BigDecimal.class.equals(fieldBean.getSetterType()) && String.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, new BigDecimal((String)sourceValue));
                    continue;
                }
                if (String.class.equals(fieldBean.getSetterType()) && BigDecimal.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (BigDecimal)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    targetMethod.invoke(target, ((BigDecimal)sourceValue).toPlainString());
                    continue;
                }
                if (String.class.equals(fieldBean.getSetterType()) && Date.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (Date)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    String dateStr = String.valueOf(((Date)sourceValue).getTime());
                    if ("14400000".equals(dateStr)) {
                        dateStr = "";
                    }
                    targetMethod.invoke(target, dateStr);
                    continue;
                }
                if (String.class.equals(fieldBean.getSetterType()) && Long.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (Long)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    targetMethod.invoke(target, String.valueOf(sourceValue));
                    continue;
                }
                if (Long.class.equals(fieldBean.getSetterType()) && String.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, Long.parseLong((String)sourceValue));
                    continue;
                }
                if (Integer.class.equals(fieldBean.getSetterType()) && String.class.equals(fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, Integer.parseInt((String)sourceValue));
                    continue;
                }
                if (!Long.class.equals(fieldBean.getSetterType()) || !Date.class.equals(fieldBean.getGetterType()) || (sourceValue = (Date)sourceMethod.invoke(source, new Object[0])) == null) continue;
                targetMethod.invoke(target, ((Date)sourceValue).getTime());
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (Throwable th) {
                throw new FatalBeanException("Could not copy property '" + fieldBean.getFieldName() + "' from source to target", th);
            }
        }
    }

    public static String getGetterOrSetterName(String fieldName, String prefix) {
        String first = fieldName.substring(0, 1);
        String last = fieldName.substring(1);
        return prefix + first.toUpperCase() + last;
    }

    public static List<String> getFieldNameList(Class source) {
        Field[] rowFields;
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field rowField : rowFields = source.getDeclaredFields()) {
            rowField.setAccessible(true);
            fieldList.add(rowField.getName());
        }
        return fieldList;
    }

    public static String getObjectValue(Object source, String fieldName) {
        String result = "";
        String getMethodName = BeanUtil.getGetterOrSetterName(fieldName, "get");
        try {
            Method sourceMethod = null;
            try {
                sourceMethod = source.getClass().getDeclaredMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                Class<?> clazz = source.getClass();
                sourceMethod = clazz.getSuperclass().getDeclaredMethod(getMethodName, new Class[0]);
            }
            sourceMethod.setAccessible(true);
            if (Date.class.equals(sourceMethod.getReturnType())) {
                Date sourceValue = (Date)sourceMethod.invoke(source, new Object[0]);
                if (sourceValue != null) {
                    result = String.valueOf(sourceValue.getTime());
                }
            } else if (BigDecimal.class.equals(sourceMethod.getReturnType())) {
                BigDecimal sourceValue = (BigDecimal)sourceMethod.invoke(source, new Object[0]);
                if (sourceValue != null) {
                    result = sourceValue.toPlainString();
                }
            } else if (Long.class.equals(sourceMethod.getReturnType())) {
                Long sourceValue = (Long)sourceMethod.invoke(source, new Object[0]);
                if (sourceValue != null) {
                    result = String.valueOf(sourceValue);
                }
            } else if (Integer.class.equals(sourceMethod.getReturnType())) {
                Integer sourceValue = (Integer)sourceMethod.invoke(source, new Object[0]);
                if (sourceValue != null) {
                    result = String.valueOf(sourceValue);
                }
            } else if (String.class.equals(sourceMethod.getReturnType())) {
                result = (String)sourceMethod.invoke(source, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void setObjectValue(Object target, String fieldValue, String fieldKey) {
        String setMethodName = BeanUtil.getGetterOrSetterName(fieldKey, "set");
        String getMethodName = BeanUtil.getGetterOrSetterName(fieldKey, "get");
        try {
            Method targetMethod = null;
            Class<?> fieldType = null;
            try {
                fieldType = target.getClass().getDeclaredMethod(getMethodName, new Class[0]).getReturnType();
                targetMethod = target.getClass().getDeclaredMethod(setMethodName, fieldType);
            }
            catch (NoSuchMethodException nsme) {
                Class<?> clazz = target.getClass();
                fieldType = clazz.getSuperclass().getDeclaredMethod(getMethodName, new Class[0]).getReturnType();
                targetMethod = clazz.getSuperclass().getDeclaredMethod(setMethodName, fieldType);
            }
            targetMethod.setAccessible(true);
            if (Date.class.equals(fieldType)) {
                targetMethod.invoke(target, new Date(Long.parseLong(fieldValue)));
            } else if (BigDecimal.class.equals(fieldType)) {
                targetMethod.invoke(target, new BigDecimal(fieldValue));
            } else if (Long.class.equals(fieldType)) {
                targetMethod.invoke(target, Long.parseLong(fieldValue));
            } else if (Integer.class.equals(fieldType)) {
                targetMethod.invoke(target, Integer.parseInt(fieldValue));
            } else if (String.class.equals(fieldType)) {
                targetMethod.invoke(target, fieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T, S> void copyList(List<T> sourceList, List<S> targetList, Class<S> targetClazz) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(sourceList)) {
            Object targetObject = null;
            for (T sourceObject : sourceList) {
                try {
                    targetObject = targetClazz.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                BeanUtil.copyProperties(sourceObject, targetObject);
                targetList.add(targetObject);
            }
        }
    }
}

