/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.rule.center.client.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.FieldLimitEnum;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FieldLimitUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldLimitUtils.class);

    public static List<FieldLimit> string2FieldLimit(String fieldLimitStr) {
        try {
            ArrayList<FieldLimit> ruleFieldLimits = new ArrayList<FieldLimit>();
            if (StringUtils.isEmpty((Object)fieldLimitStr)) {
                return ruleFieldLimits;
            }
            List jsonObjects = JSONArray.parseArray((String)fieldLimitStr, JSONObject.class);
            for (JSONObject fieldLimit : jsonObjects) {
                String limitType = fieldLimit.getString("limitType");
                if (StringUtils.isEmpty((Object)limitType)) {
                    throw new RuntimeException("fieldLimit \u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u52a0\u8f7d");
                }
                FieldLimitEnum ruleFieldLimitEnum = FieldLimitEnum.fromValue(limitType);
                if (null == ruleFieldLimitEnum) {
                    throw new RuntimeException(String.format("fieldLimit ->limitType = %s \u4e0d\u5408\u6cd5", limitType));
                }
                Object fieldLimitObj = fieldLimit.toJavaObject(ruleFieldLimitEnum.limitClass());
                ruleFieldLimits.add((FieldLimit)fieldLimitObj);
            }
            return ruleFieldLimits;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("##### string2FieldLimit \u5f02\u5e38: {}", (Throwable)e);
            throw new RuntimeException("##### string2FieldLimit \u5f02\u5e38" + e);
        }
    }

    public static List<FieldLimit> jsonObjects2FieldLimit(List<JSONObject> jsonObjects) {
        try {
            return FieldLimitUtils.string2FieldLimit(jsonObjects.toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("##### jsonObjects2FieldLimit \u5f02\u5e38: {}", (Throwable)e);
            throw new RuntimeException("##### jsonObjects2FieldLimit \u5f02\u5e38" + e);
        }
    }

    public static <T> T getFieldLimit(List<FieldLimit> fieldLimits, FieldLimitEnum limitEnum) {
        for (FieldLimit fieldLimit : fieldLimits) {
            if (!fieldLimit.getLimitType().equals(limitEnum.code())) continue;
            return (T)fieldLimit;
        }
        return null;
    }

    public static <T> T getFieldLimitByJsonObjects(List<JSONObject> fieldLimits, FieldLimitEnum limitEnum) {
        return FieldLimitUtils.getFieldLimit(JsonUtils.writeObjectToFastJson(fieldLimits), limitEnum);
    }

    public static <T> T getFieldLimit(String fieldLimit, FieldLimitEnum limitEnum) {
        try {
            if (StringUtils.isEmpty((Object)fieldLimit)) {
                return null;
            }
            List<FieldLimit> itemFieldLimits = FieldLimitUtils.string2FieldLimit(fieldLimit);
            Map itemFieldLimitMap = itemFieldLimits.stream().collect(Collectors.toMap(FieldLimit::getLimitType, Function.identity(), (v1, v2) -> v2));
            FieldLimit itemFieldLimit = (FieldLimit)itemFieldLimitMap.get(limitEnum.code());
            return (T)itemFieldLimit;
        }
        catch (Exception e) {
            log.error("##### getFieldLimit \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }
}

