package com.xforceplus.ant.coop.rule.center.client.api.baseconfig;

import com.xforceplus.ant.coop.rule.center.client.data.baseconfig.GetFeeWay;
import com.xforceplus.ant.coop.rule.center.client.data.baseconfig.UpdateFeeWay;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * Describe: 基础配置-计费方式 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "fee-way-configs", description = "基础配置-计费方式 接口服务")
public interface FeeWayConfigApi {

    @ApiOperation("配置-计费方式更新")
    @RequestMapping(value = "/fee-way-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@RequestBody @Valid UpdateFeeWay input);

    @ApiOperation("租户计费配置")
    @RequestMapping(value = "/fee-way-configs/{configObjId}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetFeeWay> get(@PathVariable Long configObjId);

}
