package com.xforceplus.ant.coop.rule.center.client.api.canary;


import com.xforceplus.ant.coop.rule.center.client.data.canary.request.CreateCanaryConfigScope;
import com.xforceplus.ant.coop.rule.center.client.data.canary.request.QueryCanaryCoordination;
import com.xforceplus.ant.coop.rule.center.client.data.canary.request.UpdateCoordinationLoginTime;
import com.xforceplus.ant.coop.rule.center.client.data.canary.response.ListCanaryCoordination;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * Describe: 灰度协同关系
 *
 * @Author xiezhongyong
 * @Date 2021-10-20
 */
@Api(value = "canary-coordinations", description = "灰度配置 接口服务")
public interface CanaryCoordinationApi {

    @ApiOperation("灰度协同关系数据列表查询")
    @RequestMapping(value = "/canary-coordinations/list", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCanaryCoordination>> list(@RequestBody @Valid QueryCanaryCoordination input);


    @ApiOperation("更新协同关系登录时间")
    @RequestMapping(value = "/canary-coordinations/login-time", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateCoordinationLoginTime(@RequestBody @Valid UpdateCoordinationLoginTime input);



    @ApiOperation("刷新所有灰度协同关系(清空+全量X协同关系同步)")
    @RequestMapping(value = "/canary-coordinations/sync/all", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> syncAll();

    @ApiOperation("指定时间同步X协同关系数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "createTime", value = "创建时间(时间格式:yyyy-MM-dd HH:mm:ss)", dataType = "String", paramType = "query")}
    )
    @RequestMapping(value = "/canary-coordinations/sync", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> syncByCreateTime(@RequestParam(value = "createTime", required = false) String createTime);


}
