package com.xforceplus.ant.coop.rule.center.client.api.canary;


import com.xforceplus.ant.coop.rule.center.client.data.canary.request.MindCanaryData;
import com.xforceplus.ant.coop.rule.center.client.data.canary.request.PreciseCanaryData;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * Describe: 灰度服务端调用-调用
 *
 * @Author xiezhongyong
 * @Date 2021-11-12
 */
@Api(value = "canary-servers", description = "灰度服务端 接口服务")
public interface CanaryServerApi {

    @ApiOperation("服务端调用灰度数据添加(智能添加,不需要指定灰度代码，耗时比较长，不适合批量操作)")
    @RequestMapping(value = "/canary-servers/canaryData/mind", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> addMindCanaryData(@RequestBody @Valid MindCanaryData input);

    @ApiOperation("服务端调用灰度数据添加(指定灰度代码添加，精准快，推荐使用)")
    @RequestMapping(value = "/canary-servers/canaryData/precise", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> addPreciseCanaryData(@RequestBody @Valid PreciseCanaryData input);


}
