package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.BatchUpdateBillType;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListPhoenixBillType;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListBillType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务单类型 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "bill-types", description = "业务单类型 接口服务")
public interface BillTypeApi {


    @ApiOperation("配置方业务单类型列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "commonFalg", value = "是否查询通用业务单名(1:是，不传：否)", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "billClass", value = "单据类型分类(COOP：协同单据类型；NORM：4.0标准单据类型, 不传参数查询所有)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态(1:启用;0:停用, 不传参数查询所有) ", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/bill-types", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> list(@RequestParam(value = "configObjId") Long configObjId,
                                        @RequestParam(value = "commonFalg", required = false) Integer commonFalg,
                                        @RequestParam(value = "billClass", required = false) String billClass,
                                        @RequestParam(value = "status", required = false) Integer status);


    @ApiOperation("配置方业务单类型列表(数据模板modelTypes)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "modelTypes", value = "数据模板modelType列表", dataType = "List", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateStatus", value = "数据模板状态(0:启用,1:停用)", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/bill-types/by-model-types", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listByModelType(@RequestParam(value = "configObjId") Long configObjId,
                                                   @RequestParam(value = "modelTypes") List<Integer> modelTypes,
                                                   @RequestParam(value = "templateStatus", required = false) Integer templateStatus);


    @ApiOperation("配置方业务单类型列表(客户页面使用)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/bill-types/client", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listClint(@RequestParam(value = "configObjId") Long configObjId);


    @ApiOperation("配置方业务单类型列表(基础配置调用,该接口带自动同步 4.0 单据类型功能)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "status", value = "状态(1:启用;0:停用, 不传参数查询所有) ", dataType = "Integer", paramType = "query")
    }
    )
    @RequestMapping(value = "/bill-types/basic-config", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listBasicConfig(@RequestParam(value = "configObjId") Long configObjId,
                                                   @RequestParam(value = "status", required = false) Integer status);

    @ApiOperation("单据类型修改")
    @RequestMapping(value = "/bill-types", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchUpdate(@RequestBody @Valid BatchUpdateBillType input);


    @ApiOperation("4.0 单据类型查询)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "billTypeId", value = "4.0单据类型ID", dataType = "Long", paramType = "query")
    }
    )
    @RequestMapping(value = "/bill-types/phoenix", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListPhoenixBillType>> listPhoenixBillType(@RequestParam(value = "tenantId") Long tenantId,
                                                              @RequestParam(value = "billTypeId", required = false) Long billTypeId);


    @ApiOperation("同步所有购方单据类型Code(根据已有单据名称 同步4.0 单据id)")
    @RequestMapping(value = "/bill-types/sync/all/pur", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> syncAllPurBillType();

}
